/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.discoverersmanager.ui.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.discoverersmanager.Discoverer;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoverersManager;

/**
 * @author Gabriel Barbier
 * 
 */
public class DiscovererLaunchConfigurationDelegate implements
		ILaunchConfigurationDelegate {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.debug.core.model.ILaunchConfigurationDelegate#launch(org.
	 * eclipse.debug.core.ILaunchConfiguration, java.lang.String,
	 * org.eclipse.debug.core.ILaunch,
	 * org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void launch(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor) throws CoreException {
		try {
			/*
			 * Do we have to validate launch configuration before execution ? it
			 * seems to be ...
			 */
			String kind = configuration.getAttribute(
					DiscovererLaunchConstants.discovererKind, "");
			String sourcePath = configuration.getAttribute(
					DiscovererLaunchConstants.discovererSourcePath, "");
			String targetPath = configuration.getAttribute(
					DiscovererLaunchConstants.discovererTargetPath, "");

			Discoverer discoverer = DiscoverersManager
					.getDiscoverer(kind);

			/*
			 * Conversion of source path into source element
			 */
			Object source = null;
			IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
			IPath rootPath = root.getFullPath();
			IPath path = rootPath.append(sourcePath);
			/*
			 * It could be a file, a folder or a project ...
			 */
			IContainer iproject = null;
			if (path.segmentCount() == 1) {
				iproject = root.getProject(sourcePath);
			} else {
				iproject = root.getFolder(path);
			}
			if ((iproject != null) && (iproject.exists())) {
				source = iproject;
			} else {
				IFile ifile = root.getFile(path);
				source = ifile;
			}

			/*
			 * Conversion of target path into an URI
			 */
			URI target = null;
			if (targetPath.length() > 0) {
				if (rootPath.isValidPath(targetPath)) {
					path = rootPath.append(targetPath);
					try {
						IFile ifile = root.getFile(path);
						target = URI.createFileURI(ifile.getLocation()
								.toString());
					} catch (IllegalArgumentException iae) {
						iae.printStackTrace();
					}
				}
			}
			discoverer.discoverElement(source, target);
		} catch (Exception e) {
			IStatus status = new Status(IStatus.ERROR,
					DiscoverersManager.PLUGIN_ID,
					"Please, check your discoverer configuration.", e);
			throw new CoreException(status);
		}
	}

}
