/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.discoverersmanager;

import java.util.List;
import java.util.Map;

import org.eclipse.swt.widgets.Shell;

/**
 * @author Gabriel Barbier
 *
 */
public interface ExtendedInterface extends Discoverer {

	public static interface DiscovererParameter {
		public String getName();
		public String getDescription();
		public ParameterKind getParameterKind();
		public boolean isRequired();
		public Class<?> getType();
	}
	
	public static enum ParameterKind {
		in, out, inout
	}
	public void setShell(Shell shell);
	
	public List<DiscovererParameter> getDiscovererParameters();
	
	public void discoverElement(final Object source, final Map<DiscovererParameter, Object> parameters);
}
