/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.editor.adapters;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;

/**
 * An adapter factory that returns MiaReflectiveItemProvider adapters for model elements.
 */
public class MiaReflectiveItemProviderAdapterFactory extends ReflectiveItemProviderAdapterFactory {

	/** The user settings for the model editor */
	private final EditorConfiguration editorConfiguration;

	public MiaReflectiveItemProviderAdapterFactory(EditorConfiguration editorConfiguration) {

		this.editorConfiguration = editorConfiguration;
		this.reflectiveItemProviderAdapter = null;

		this.supportedTypes.add(IStructuredItemContentProvider.class);
		this.supportedTypes.add(ITreeItemContentProvider.class);
		this.supportedTypes.add(IItemPropertySource.class);
		this.supportedTypes.add(IEditingDomainItemProvider.class);
		this.supportedTypes.add(IItemLabelProvider.class);
		this.supportedTypes.add(ITableItemLabelProvider.class);
		this.supportedTypes.add(IItemColorProvider.class);
		this.supportedTypes.add(IItemFontProvider.class);
	}

	/**
	 * MiaReflectiveItemProvider has state: cannot use singleton => create a new adapter each time
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return new MiaReflectiveItemProvider(this, this.editorConfiguration);
	}
}