/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.editor.popup.actions;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.editors.EcoreEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenModelAction implements IObjectActionDelegate {

	private List<?> selection = null;
	private IWorkbenchPage activePage = null;

	public OpenModelAction() {
	}

	public void run(IAction action) {
		if (this.activePage == null || this.selection == null)
			return;

		for (Object selected : this.selection) {
			if (selected instanceof IFile) {
				IFile file = (IFile) selected;
				try {
					IDE.openEditor(this.activePage, file, EcoreEditor.EDITOR_ID, true);
				} catch (PartInitException e) {
					MoDiscoEditorPlugin.INSTANCE.log(e);
				}
			}
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			this.selection = structuredSelection.toList();
		}
	}

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.activePage = targetPart.getSite().getPage();
	}
}
