/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.workflow.ui;


import org.eclipse.gmt.modisco.workflow.Constant;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.jface.wizard.Wizard;

public class DriversWizard extends Wizard{
	
	private DriverPage driver;
	private LoadLauncherPage loadLauncher;
	private ControllerDriverPage controllerDriverpage;
	private ControllerWorkflowTransformation controllerWorkflow;
	private Constant mode;
	
	/**
	 * Class constructor
	 * @param controllerWorkflow The controller managing the workflow
	 * @param controllerDriverpage The controller managing the display
	 * @param mode Opening mode of wizard (add or edit or load)
	 */
	public DriversWizard(ControllerWorkflowTransformation controllerWorkflow,
			ControllerDriverPage controllerDriverpage, Constant mode){
		this.controllerWorkflow = controllerWorkflow;
		this.mode = mode;
		this.controllerDriverpage = controllerDriverpage;
		if(mode.equals(Constant.addMode)){
			this.setWindowTitle("Add a MoDiscoWork");
		}else if(mode.equals(Constant.editMode)){
			this.setWindowTitle("Edit a MoDiscoWork");
		}else{
			this.setWindowTitle("Load a MoDiscoWork");
		}
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#addPages()
	 */
	@Override
	public final void addPages() {
		this.driver = new DriverPage("Driver selected",this.mode,this.controllerWorkflow.getGroup());
		this.driver.setController(this.controllerDriverpage);
		if(this.mode.equals(Constant.addMode)){
			this.addPage(new ListDriversPage("List of drivers",this.controllerDriverpage));
		}
		if(this.mode.equals(Constant.loadMode)){
			this.loadLauncher = new LoadLauncherPage("List of Launcher",this.controllerDriverpage);
			this.addPage(this.loadLauncher);
		}
		if(!this.mode.equals(Constant.loadMode)){
			this.addPage(this.driver);
		}
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	@Override
	public boolean performFinish() {
		if(this.mode.equals(Constant.addMode)){
			this.controllerDriverpage.launchPerformFinish();
			this.controllerWorkflow.addMoDiscoWork(this.controllerDriverpage.getCurrentDriver().getTypeLaunchConfig(),-1,this.driver.getTransformationName(),true);
		}else if (this.mode.equals(Constant.editMode)){
			this.controllerDriverpage.launchPerformFinish();
			this.controllerWorkflow.performFinishEditTransformation(this.driver.getTransformationName());
		}else if (this.mode.equals(Constant.loadMode)){
			this.controllerWorkflow.addMoDiscoWork(this.loadLauncher.getLauncherType(),-1,this.loadLauncher.getTransformationName(),true);
		}
		return true;
	}	
}
