/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.workflow;

import java.util.List;

import org.eclipse.emf.ecore.EObject;

public interface WorkflowInterface{

	/**
	 * Add a component in the MoDiscoWorkwlow
	 * @param name Component name
	 * @param parameters The parameter of component
	 */
	public void addComponentWorkflow(String name, EObject parameters);
	//public void addComponentWorkflow(String name, Object parameters);
	
	/**
	 * Allows to retrieve a component at index specified
	 * @param index Component index
	 * @return the parameter of the component
	 */
	public EObject getComponent(int index);
	//public Object getComponent(int index);
	
	/**
	 * Change a component of MoDiscoWorkflow
	 * @param index Component index
	 * @param parameter the parameter of the component
	 */
	public void setComponent(int index, EObject parameter);
	//public void setComponent(int index, Object parameter);
	
	/**
	 * Allows to retrieve all components of the MoDiscoWorkflow
	 * @return a component list
	 */
	public List<EObject> getAllComponents();
	//public List<Object> getAllComponents();
	
	/**
	 * Allows to delete a component at index specified
	 * @param index Component index
	 */
	public void removeComponent(int index);
}
