package org.eclipse.gmt.modisco.workflow.defaultengine;

import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.workflow.Constant;
import org.eclipse.gmt.modisco.workflow.DriverExecutionInterface;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.WorkflowExecutionInterface;
import org.eclipse.gmt.modisco.workflow.modiscowork.MoDiscoWork;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class WorkflowExecutionImpl implements WorkflowExecutionInterface {

	@SuppressWarnings("unchecked")
	public void launchWorkflow(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor) {
		WorkflowModelImpl workflowImpl = new WorkflowModelImpl();
		workflowImpl.initialization(configuration, null);
		List<? extends EObject> listComponent = workflowImpl.getAllComponents();
		List<MoDiscoWork> listModiscoWork = (List<MoDiscoWork>)listComponent;
		for (MoDiscoWork modiscoWork : listModiscoWork) {
			DriverExecutionInterface driver = findPlugIn(modiscoWork.getType());
			if (driver != null) {
				ILaunchConfiguration conf = getLaunchConfigurationFromName(modiscoWork.getName());
				ILaunchConfigurationWorkingCopy config = null;
				try {
					config = conf.getWorkingCopy();
				} catch (CoreException e) {
					e.printStackTrace();
				}
				driver.launch(config, launch);
			} else {
				MessageDialog.openError(new Shell(), "Plug-in not found",
						"The plug-in with the type " + modiscoWork.getType()
								+ " not found");
			}
		}
	}

	/**
	 * Allows to retrieve a instance of {@link DriverExecutionInterface} for execute a
	 * configuration
	 * 
	 * @param type
	 *            The launcher type
	 * @return a instance of {@link DriverExecutionInterface} corresponding at type
	 *         specified
	 */
	private DriverExecutionInterface findPlugIn(String type) {
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry
				.getExtensionPoint(Constant.nameExtensionPointDriver); //$NON-NLS-1$

		for (IExtension extension : point.getExtensions()) {
			for (IConfigurationElement element : extension
					.getConfigurationElements()) {
				if (element.getName().equals(Constant.nameElementDriver)) {
					try {
						DriverInterface driver = (DriverInterface) element
								.createExecutableExtension("class");
						if (driver.getTypeLaunchConfig().equals(type)) {
							return findExecutionPlugIn(extension
									.getUniqueIdentifier());
						}
					} catch (CoreException e) {
						e.printStackTrace();
					}
				}
			}
		}
		return null;
	}

	/**
	 * Allows to retrieve a instance of {@link DriverExecutionInterface} for execute a
	 * configuration
	 * 
	 * @param id
	 *            The id of plug-in specified
	 * @return a instance of {@link DriverExecutionInterface} corresponding at id
	 *         specified
	 */
	private DriverExecutionInterface findExecutionPlugIn(String id) {
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry
				.getExtensionPoint(Constant.nameExtensionPointDriver); //$NON-NLS-1$

		for (IExtension extension : point.getExtensions()) {
			if (extension.getUniqueIdentifier().equals(id)) {
				for (IConfigurationElement element : extension
						.getConfigurationElements()) {
					if (element.getName().equals(Constant.nameElementExecution)) {
						try {
							return (DriverExecutionInterface) element
									.createExecutableExtension("class");
						} catch (CoreException e) {
							e.printStackTrace();
						}
					}
				}
			}
		}
		return null;
	}
	
	/**
	 * Allows to find the good instance of LaunchCOnfiguration corresponding at path
	 * @param configName Name of LaunchConfiguration
	 * @return An instance of launchConfiguration corresponding at path
	 */
	private ILaunchConfiguration getLaunchConfigurationFromName(String configName){
		ILaunchConfiguration configuration = null;
		try {
			for(ILaunchConfiguration config : DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations()){
				if(config.getName().equals(configName)){
					configuration = config;
					break;
				}
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return configuration;
	}

}
