/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.atl.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.workflow.AbstractDriverCore;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.driver.atl.Constant;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Direction;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.m2m.atl.common.ATLLaunchConstants;

public class LaunchDriverATL extends AbstractDriverCore implements DriverInterface {

	public String getTypeLaunchConfig() {
		return Constant.typeLaunchConfiguration;
	}

	@SuppressWarnings("unchecked")
	public List<WorkParameter> getParameters(ILaunchConfiguration configuration) {
		List<WorkParameter> parameters = new ArrayList<WorkParameter>();
		try {
			WorkParameter param = createOneWorkParameter(ATLLaunchConstants.ATL_FILE_NAME,Direction.IN,"Transformation file name",true,String.class);
			param.setValue(createStringValue(configuration.getAttribute(ATLLaunchConstants.ATL_FILE_NAME,(String)null)));
			parameters.add(param);
			
			WorkParameter param2 = createOneWorkParameter(ATLLaunchConstants.ATL_VM,Direction.IN,"Virtual machine name for ATL",true,String.class);
			param2.setValue(createStringValue(configuration.getAttribute(ATLLaunchConstants.ATL_VM,(String)null)));
			parameters.add(param2);

			WorkParameter param3 = createOneWorkParameter(ATLLaunchConstants.ATL_COMPILER,Direction.IN,"ATL compiler version",true,String.class);
			param3.setValue(createStringValue(configuration.getAttribute(ATLLaunchConstants.ATL_COMPILER,(String)null)));
			parameters.add(param3);
			
			WorkParameter param4 = createOneWorkParameter(ATLLaunchConstants.IS_REFINING,Direction.IN,"To refining",false,Boolean.class);
			param4.setValue(createBooleanValue(configuration.getAttribute(ATLLaunchConstants.IS_REFINING,false)));
			parameters.add(param4);
			
			WorkParameter param5 = createOneWorkParameter(ATLLaunchConstants.INPUT,Direction.IN,"Transformation inputs type",true,Map.class);
			param5.setValue(createMapValue(configuration.getAttribute(ATLLaunchConstants.INPUT,(Map<String,String>)null)));
			parameters.add(param5);
			
			WorkParameter param6 = createOneWorkParameter(ATLLaunchConstants.LIBS,Direction.IN,"The Libraries allowing to launch ATL transformation",false,Map.class);
			param6.setValue(createMapValue(configuration.getAttribute(ATLLaunchConstants.LIBS,(Map<String,String>)null)));
			parameters.add(param6);
			
			WorkParameter param7 = createOneWorkParameter(ATLLaunchConstants.MODEL_HANDLER,Direction.IN,"Model handler for the ATL transformation",true,Map.class);
			param7.setValue(createMapValue(configuration.getAttribute(ATLLaunchConstants.MODEL_HANDLER,(Map<String,String>)null)));
			parameters.add(param7);
			
			WorkParameter param8 = createOneWorkParameter(ATLLaunchConstants.MODEL_TYPE,Direction.INOUT,"Model type input and output",true,Map.class);
			param8.setValue(createMapValue(configuration.getAttribute(ATLLaunchConstants.MODEL_TYPE,(Map<String,String>)null)));
			parameters.add(param8);
			
			WorkParameter param9 = createOneWorkParameter(ATLLaunchConstants.OPTIONS,Direction.IN,"Options to launch ATL transformation",false,Map.class);		
			param9.setValue(createMapValue(configuration.getAttribute(ATLLaunchConstants.OPTIONS,(Map<String,String>)null)));
			parameters.add(param9);
			
			WorkParameter param10 = createOneWorkParameter(ATLLaunchConstants.OUTPUT,Direction.OUT,"Transformation outputs type",true,Map.class);
			param10.setValue(createMapValue(configuration.getAttribute(ATLLaunchConstants.OUTPUT,(Map<String,String>)null)));
			parameters.add(param10);
			
			WorkParameter param11 = createOneWorkParameter(ATLLaunchConstants.PATH,Direction.INOUT,"Path of the models, metamodels, outputs and inputs",true,Map.class);
			param11.setValue(createMapValue(configuration.getAttribute(ATLLaunchConstants.PATH,(Map<String,String>)null)));
			parameters.add(param11);
			
			WorkParameter param12 = createOneWorkParameter(ATLLaunchConstants.SUPERIMPOSE,Direction.IN,"Superimpose",false,List.class);
			param12.setValue(createValueStringList(configuration.getAttribute(ATLLaunchConstants.SUPERIMPOSE,(List<String>)null)));
			parameters.add(param12);
	
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return parameters;
	}
}
