/**
 * 
 * Copyright (c) 2009 Hatha Systems.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nikolai Mansourov (Hatha Systems) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - minor evolutions for version 1.1
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.omg.kdm.core.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.gmt.modisco.omg.kdm.core.CorePackage;
import org.eclipse.gmt.modisco.omg.kdm.core.KDMEntity;
import org.eclipse.gmt.modisco.omg.kdm.core.KDMRelationship;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>KDM Relationship</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.core.impl.KDMRelationshipImpl#getGenericFrom <em>Generic From</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.core.impl.KDMRelationshipImpl#getGenericTo <em>Generic To</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class KDMRelationshipImpl extends ModelElementImpl implements KDMRelationship {
	/**
	 * The cached value of the '{@link #getGenericFrom() <em>Generic From</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGenericFrom()
	 * @generated
	 * @ordered
	 */
	protected KDMEntity genericFrom;
	/**
	 * The cached value of the '{@link #getGenericTo() <em>Generic To</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGenericTo()
	 * @generated
	 * @ordered
	 */
	protected KDMEntity genericTo;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected KDMRelationshipImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CorePackage.Literals.KDM_RELATIONSHIP;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KDMEntity getGenericFrom() {
		if (genericFrom != null && genericFrom.eIsProxy()) {
			InternalEObject oldGenericFrom = (InternalEObject)genericFrom;
			genericFrom = (KDMEntity)eResolveProxy(oldGenericFrom);
			if (genericFrom != oldGenericFrom) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, CorePackage.KDM_RELATIONSHIP__GENERIC_FROM, oldGenericFrom, genericFrom));
			}
		}
		return genericFrom;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KDMEntity basicGetGenericFrom() {
		return genericFrom;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGenericFrom(KDMEntity newGenericFrom, NotificationChain msgs) {
		KDMEntity oldGenericFrom = genericFrom;
		genericFrom = newGenericFrom;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CorePackage.KDM_RELATIONSHIP__GENERIC_FROM, oldGenericFrom, newGenericFrom);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KDMEntity getGenericTo() {
		if (genericTo != null && genericTo.eIsProxy()) {
			InternalEObject oldGenericTo = (InternalEObject)genericTo;
			genericTo = (KDMEntity)eResolveProxy(oldGenericTo);
			if (genericTo != oldGenericTo) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, CorePackage.KDM_RELATIONSHIP__GENERIC_TO, oldGenericTo, genericTo));
			}
		}
		return genericTo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KDMEntity basicGetGenericTo() {
		return genericTo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGenericTo(KDMEntity newGenericTo, NotificationChain msgs) {
		KDMEntity oldGenericTo = genericTo;
		genericTo = newGenericTo;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CorePackage.KDM_RELATIONSHIP__GENERIC_TO, oldGenericTo, newGenericTo);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KDMEntity getTo() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CorePackage.KDM_RELATIONSHIP__GENERIC_FROM:
				if (genericFrom != null)
					msgs = ((InternalEObject)genericFrom).eInverseRemove(this, CorePackage.KDM_ENTITY__OUTBOUND, KDMEntity.class, msgs);
				return basicSetGenericFrom((KDMEntity)otherEnd, msgs);
			case CorePackage.KDM_RELATIONSHIP__GENERIC_TO:
				if (genericTo != null)
					msgs = ((InternalEObject)genericTo).eInverseRemove(this, CorePackage.KDM_ENTITY__INBOUND, KDMEntity.class, msgs);
				return basicSetGenericTo((KDMEntity)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CorePackage.KDM_RELATIONSHIP__GENERIC_FROM:
				return basicSetGenericFrom(null, msgs);
			case CorePackage.KDM_RELATIONSHIP__GENERIC_TO:
				return basicSetGenericTo(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CorePackage.KDM_RELATIONSHIP__GENERIC_FROM:
				if (resolve) return getGenericFrom();
				return basicGetGenericFrom();
			case CorePackage.KDM_RELATIONSHIP__GENERIC_TO:
				if (resolve) return getGenericTo();
				return basicGetGenericTo();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CorePackage.KDM_RELATIONSHIP__GENERIC_FROM:
				return genericFrom != null;
			case CorePackage.KDM_RELATIONSHIP__GENERIC_TO:
				return genericTo != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KDMEntity getFrom() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

} //KDMRelationshipImpl
