/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.workflow;

import java.util.List;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.workflow.ui.common.MoDiscoWorkParameter;

public interface WorkflowModelInterface{

	/**
	 * Add a component in the MoDiscoWorkwlow
	 * @param name Component name
	 * @param modiscowork The MoDiscoWork which represents the component
	 * @param paramList The parameters of component
	 */
	public void addComponentWorkflow(String name, EObject modiscowork, List<MoDiscoWorkParameter> paramList);
	
	/**
	 * Allows to retrieve a component at index specified
	 * @param index Component index
	 * @return the parameter of the component
	 */
	public EObject getComponent(int index);
	
	/**
	 * Change a component of MoDiscoWorkflow
	 * @param index Component index
	 * @param parameter the parameter of the component
	 */
	public void setComponent(int index, EObject parameter);
	
	/**
	 * Allows to retrieve all components of the MoDiscoWorkflow
	 * @return a component list
	 */
	public List<EObject> getAllComponents();
	
	/**
	 * Allows to delete a component at index specified
	 * @param index Component index
	 */
	public void removeComponent(int index);

	/**
	 * Allows to initialize or load the workflow
	 * @param configuration Launch configuration associated
	 * @param path Workflow resource path
	 */
	public void initialization(ILaunchConfiguration configuration, String path);
	
	/**
	 * Allows to save the resource
	 * @param configuration Launch configuration associated
	 */
	public void save(ILaunchConfigurationWorkingCopy configuration);
	
	/**
	 * Allows to move the resource
	 * @param path Workflow resource path
	 */
	public void moveResource(String path);

	/**
	 * Allows to remove the resource
	 */
	void removeResource(String resourcePath);
	
}
