/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.workflow.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constant;

public class MoDiscoWorkflowTabGroup extends
		AbstractLaunchConfigurationTabGroup {
	private ILaunchConfigurationTab wfTab;
	private ILaunchConfigurationTab export;
	private ILaunchConfigurationTab common;

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTabGroup#createTabs(org.eclipse.debug.ui.ILaunchConfigurationDialog, java.lang.String)
	 */
	public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
		this.wfTab = new WorkflowTransformationTab();
		this.export = new MoDiscoExportTab();
		this.common = new MoDiscoWorkflowCommonTab();
		setTabs(new ILaunchConfigurationTab[] {this.wfTab,this.export,this.common});
	}
	
	@Override
	public void initializeFrom(ILaunchConfiguration configuration) {
		this.common.initializeFrom(configuration);
		((WorkflowTransformationTab) this.wfTab).setResourcePath(((MoDiscoWorkflowCommonTab)this.common).getResourcePath());
		this.wfTab.initializeFrom(configuration);
		DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(new ILaunchConfigurationListener(){
			public void launchConfigurationAdded(ILaunchConfiguration configuration) {}
			public void launchConfigurationChanged(ILaunchConfiguration configuration) {}
			public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
				String resourcePath = null;
				if (!configuration.isLocal()) {				
					IPath path = configuration.getFile().getLocation().removeLastSegments(1).append(configuration.getName()).addFileExtension(Constant.extension);
					resourcePath = path.toString();
				} else {
					resourcePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".metadata").append(".plugins").append(Activator.PLUGIN_ID).append(configuration.getName()).addFileExtension(Constant.extension).toString();
				}
				((WorkflowTransformationTab) MoDiscoWorkflowTabGroup.this.wfTab).getController().removeResource(resourcePath);
			}
		});
		this.export.initializeFrom(configuration);
	}
		
	@Override
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		super.performApply(configuration);
		((WorkflowTransformationTab) this.wfTab).getController().saveWorkflowResource(configuration);
		((WorkflowTransformationTab) this.wfTab).getController().moveWorkflowResource(((MoDiscoWorkflowCommonTab)this.common).getResourcePath());
		//For rename configuration
		if(!configuration.getOriginal().getName().equals(configuration.getName())){
			String resourcePath = null;
			if (!configuration.isLocal()) {				
				IPath path = configuration.getFile().getLocation().removeLastSegments(1).append(configuration.getName()).addFileExtension(Constant.extension);
				resourcePath = path.toString();
			} else {
				resourcePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".metadata").append(".plugins").append(Activator.PLUGIN_ID).append(configuration.getName()).addFileExtension(Constant.extension).toString();
			}
			((WorkflowTransformationTab) this.wfTab).getController().moveWorkflowResource(resourcePath);
		}
		//Refresh Package explorer
		try {
			ResourcesPlugin.getWorkspace().getRoot().refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
		} catch (CoreException e) {
			e.printStackTrace();
		}
		//Export to discoverer project and change the workflow type
		try {
			if(configuration.getAttribute(Constant.workflowExport,false)){
				((WorkflowTransformationTab) this.wfTab).getController().exportMoDiscoWorkflowToDiscovererProject(configuration.getName());
			}
			((WorkflowTransformationTab) this.wfTab).getController().changeWorkflowType(configuration.getAttribute(Constant.idWorkflow,Constant.idMinimaliste),configuration);
		} catch (CoreException e) {
			e.printStackTrace();
		}
		
	}
}
