package org.eclipse.gmt.modisco.workflow.ui.common;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constant;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class WorkflowTypeDialog extends Dialog{

	private Table workflowTypeTable;
	private Map<TableItem,String> idWorkflowMap;
	private String nameWorkflowSelected;
	private String idWorkflowSelected;
	private Button btOk;
	
	/**
	 * Class constructor
	 */
	public WorkflowTypeDialog(Shell shell){
		super(shell);
		Window.setDefaultImage(Activator.getImageDescriptor(
				Constant.pathExportImage).createImage());
		this.idWorkflowMap = new HashMap<TableItem, String>();
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createContents(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createContents(Composite parent) {
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.verticalSpan = 10;
		
		GridLayout dialogLayout = new GridLayout();
		dialogLayout.numColumns = 1;
		dialogLayout.horizontalSpacing = 9;
		parent.setLayout(dialogLayout);
		
		Label labelWorkflow = new Label(parent, SWT.NONE);
		labelWorkflow.setText("Choose your workflow type");
		labelWorkflow.setLayoutData(gd);

		this.workflowTypeTable = new Table(parent, SWT.BORDER | SWT.V_SCROLL);
		GridData gdTable = new GridData(GridData.FILL_HORIZONTAL);
		gdTable.verticalSpan = 10;
		gdTable.verticalSpan = 4;
		this.workflowTypeTable.setLayoutData(gdTable);
		
		
		GridData dataButtons = new GridData(GridData.FILL_HORIZONTAL);
		dataButtons.horizontalAlignment = SWT.CENTER;
		Composite compositeButton = new Composite(parent,SWT.NULL);
		compositeButton.setLayoutData(dataButtons);
		GridLayout layoutButton = new GridLayout();
		layoutButton.numColumns = 3;
		layoutButton.horizontalSpacing = 9;
		compositeButton.setLayout(layoutButton);
		
		this.btOk = new Button(compositeButton, SWT.NONE);
		this.btOk.setText("Ok");
		Button cancel = new Button(compositeButton, SWT.NONE);
		cancel.setText("Cancel");
		cancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				WorkflowTypeDialog.this.close();
			}
		});
		this.btOk.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem itemSelected = WorkflowTypeDialog.this.workflowTypeTable.getItem(WorkflowTypeDialog.this.workflowTypeTable.getSelectionIndex());
				WorkflowTypeDialog.this.nameWorkflowSelected = itemSelected.getText();
				WorkflowTypeDialog.this.idWorkflowSelected = WorkflowTypeDialog.this.idWorkflowMap.get(itemSelected);
				WorkflowTypeDialog.this.close();
			}
		});
		initializeTable();
		this.getShell().setText("Choose your workflow type");
		return labelWorkflow;
	}

	private void initializeTable() {
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry.getExtensionPoint(Constant.nameExtensionPointWorkflow); //$NON-NLS-1$

		for (IExtension extension : point.getExtensions()) {
			for (IConfigurationElement element : extension.getConfigurationElements()) {
				if(element.getName().equals("workflow")){
					TableItem item = new TableItem(this.workflowTypeTable,SWT.NULL);
					item.setText(element.getAttribute("name"));
					this.idWorkflowMap.put(item, extension.getUniqueIdentifier());
				}
			}
		}
		if(this.idWorkflowMap.size()>0){
			this.workflowTypeTable.setSelection(0);
			this.btOk.setEnabled(true);
		}else{
			this.btOk.setEnabled(false);
		}
	}
	
	public String getIdWorkflow() {
		return this.idWorkflowSelected;
	}
	
	public String getNameWorkflow(){
		return this.nameWorkflowSelected;
	}
	
	@Override
	protected boolean isResizable() {
		return true;
	}

}
