/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.discoverersmanager.ui.launch;

import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.parametersdisplay.DiscovererParametersComposite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * @author Gabriel Barbier
 *
 */
public class DiscoverersMainTabVisualClass extends Composite {

	private Group sourceGroup = null;
	private Text sourceElementText = null;
	private Button sourceElementButton = null;
	private Group discovererKindGroup = null;
	private Group targetModelGroup = null;
	private Combo discovererKindCombo = null;
	private Text targetModelText = null;
	private Button targetModelButton = null;
	private Label targetModelLabel = null;
	private Label discoverKindLabel = null;
	private Composite targetModelComposite = null;
	private Composite rootContainer = null;
	@SuppressWarnings("unused")
	private DiscovererParametersComposite parametersContainer = null;
	
	public DiscoverersMainTabVisualClass(Composite parent, int style) {
		super(parent, style);
		initialize();
	}

	protected void updateLaunchConfigurationDialog() {
		
	}
	
	protected void modifyTextEvent() {
		System.out.println("modifyTextEvent()");
		System.out.println(this.targetModelText.getText());
	}

	protected void verifyTextEvent() {
		System.out.println("verifyText()");
		System.out.println(this.targetModelText.getText());
	}
	
	private void targetModelBrowseEvent() {
		
	}
	private void sourceBrowseEvent() {
		
	}
	
	private void initialize() {
		this.setLayout(new GridLayout());
		createRootContainer();
		
		this.setSize(new Point(424, 398));
		
		for (int i = 0; i < 5; i++) {
			this.discovererKindCombo.add("Disco " + i);
		}
	}

	/**
	 * 
	 */
	private final void createDiscovererParametersContainer() {
		this.parametersContainer = new DiscovererParametersComposite(this, SWT.NONE);		
	}

	/**
	 * This method initializes sourceGroup	
	 *
	 */
	private final void createSourceGroup() {
		GridData gridData = new GridData();
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData.grabExcessVerticalSpace = false;
		gridData.grabExcessHorizontalSpace = true;
		GridData gridData2 = new GridData();
		gridData2.grabExcessHorizontalSpace = true;
		gridData2.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		this.sourceGroup = new Group(this.rootContainer, SWT.NONE);
		this.sourceGroup.setToolTipText("The path to source element for this discoverer.");
		this.sourceGroup.setLayout(gridLayout);
		this.sourceGroup.setLayoutData(gridData);
		this.sourceGroup.setText("Source element path");
		this.sourceElementText = new Text(this.sourceGroup, SWT.BORDER);
		this.sourceElementText.setLayoutData(gridData2);
		this.sourceElementText
				.addModifyListener(new org.eclipse.swt.events.ModifyListener() {
					public void modifyText(org.eclipse.swt.events.ModifyEvent e) {
						updateLaunchConfigurationDialog();
					}
				});
		this.sourceElementButton = new Button(this.sourceGroup, SWT.NONE);
		this.sourceElementButton.setText("Browse ...");
		this.sourceElementButton
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						sourceBrowseEvent();
					}
				});
	}

	/**
	 * This method initializes discovererKindGroup	
	 *
	 */
	private final void createDiscovererKindGroup() {
		GridData gridData11 = new GridData();
		gridData11.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData11.grabExcessHorizontalSpace = true;
		GridData gridData1 = new GridData();
		gridData1.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData1.grabExcessHorizontalSpace = true;
		this.discovererKindGroup = new Group(this.rootContainer, SWT.NONE);
		this.discovererKindGroup.setLayout(new GridLayout());
		this.discovererKindGroup.setLayoutData(gridData11);
		this.discovererKindGroup.setText("Discoverer kind");
		this.discoverKindLabel = new Label(this.discovererKindGroup, SWT.NONE);
		this.discoverKindLabel.setText("Select a discoverer :");
		this.discovererKindCombo = new Combo(this.discovererKindGroup, SWT.READ_ONLY);
		this.discovererKindCombo.setLayoutData(gridData1);
		this.discovererKindCombo
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						updateLaunchConfigurationDialog();
					}
				});
	}

	/**
	 * This method initializes targetModelGroup	
	 *
	 */
	private final void createTargetModelGroup() {
		GridData gridData4 = new GridData();
		gridData4.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData4.grabExcessHorizontalSpace = true;
		GridLayout gridLayout2 = new GridLayout();
		gridLayout2.numColumns = 1;
		this.targetModelGroup = new Group(this.rootContainer, SWT.NONE);
		this.targetModelGroup.setText("Target model");
		this.targetModelGroup.setLayoutData(gridData4);
		this.targetModelGroup.setLayout(gridLayout2);
		this.targetModelLabel = new Label(this.targetModelGroup, SWT.NONE);
		this.targetModelLabel.setText("Let the path empty to use default value of discoverer.");
		createTargetModelComposite();
	}

	/**
	 * This method initializes targetModelComposite	
	 *
	 */
	private final void createTargetModelComposite() {
		GridLayout gridLayout3 = new GridLayout();
		gridLayout3.numColumns = 2;
		gridLayout3.marginWidth = 0;
		gridLayout3.horizontalSpacing = 5;
		GridData gridData7 = new GridData();
		gridData7.grabExcessHorizontalSpace = true;
		gridData7.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		this.targetModelComposite = new Composite(this.targetModelGroup, SWT.NONE);
		this.targetModelComposite.setLayoutData(gridData7);
		this.targetModelComposite.setLayout(gridLayout3);
		
		GridData gridData6 = new GridData();
		gridData6.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData6.grabExcessHorizontalSpace = true;
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.numColumns = 2;
		GridData gridData5 = new GridData();
		gridData5.grabExcessHorizontalSpace = true;
		gridData5.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		this.targetModelText = new Text(this.targetModelComposite, SWT.BORDER);
		this.targetModelText.setLayoutData(gridData6);
		this.targetModelText.addModifyListener(new org.eclipse.swt.events.ModifyListener() {
			public void modifyText(org.eclipse.swt.events.ModifyEvent e) {
				updateLaunchConfigurationDialog();
			}
		});
		this.targetModelButton = new Button(this.targetModelComposite, SWT.NONE);
		this.targetModelButton.setText("Browse ...");
		this.targetModelButton
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						targetModelBrowseEvent();
					}
				});
	}

	/**
	 * This method initializes rootContainer	
	 *
	 */
	private final void createRootContainer() {
		GridData gridData = new GridData();
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		this.rootContainer = new Composite(this, SWT.NONE);
		this.rootContainer.setLayout(gridLayout);
		this.rootContainer.setLayoutData(gridData);
		createDiscovererKindGroup();
		createSourceGroup();
		createTargetModelGroup();
		this.createDiscovererParametersContainer();		
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
