/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hugues Dubourg (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.kdm.uml2converter.popup.actions;

import java.net.URL;
import java.util.logging.Logger;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.common.core.utils.Tools;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.kdm.uml2converter.KdmToUmlConverterInterface;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertWithTraces implements IObjectActionDelegate {

	protected final Logger logger = Logger.getLogger(ATLLogger.LOGGER_ID);
	protected IFile kdmFile;
	
	/**
	 * Constructor for Action1.
	 */
	public ConvertWithTraces() {
	
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {		
		final String kdmModelPath = this.kdmFile.getLocation().toString();
		final String umlModelPath = this.kdmFile.getLocation().toString().replace(".kdm", ".uml");
		
		Job job = new Job("transform into: " + this.kdmFile.getName() + ".uml") {
			
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				AtlLogHandler logHandler = new AtlLogHandler(umlModelPath + ".log");
				ConvertWithTraces.this.logger.addHandler(logHandler);
				try{
					URL kdmModelurl = new URL("file:///" + kdmModelPath);
					KdmToUmlConverterInterface transfo = new KDMtoUML2Converter();
					Resource kdmModel = new XMIResourceImpl();
					kdmModel.setURI(URI.createFileURI(kdmModelPath));
					kdmModel.load(kdmModelurl.openStream(), null);
					URI outputURI = URI.createFileURI(umlModelPath);
					
					Resource[] out = transfo.getUML2ModelFromKDMModel(kdmModel, true, outputURI);
					Resource outputTrace = out[1];
										
					Tools.saveModel(outputTrace, umlModelPath.replace(".uml",".amw"));
					
					return Status.OK_STATUS;
				}catch (Exception e) {
					return Status.CANCEL_STATUS;
				} finally {
					try {
						ConvertWithTraces.this.logger.removeHandler(logHandler);
						logHandler.close();
						ConvertWithTraces.this.kdmFile.getParent().refreshLocal(1, null);
					} catch (Exception e1) {
						//give up
					}
				}	
			}
		};
		
		job.schedule();
		
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.kdmFile = (IFile)((IStructuredSelection)selection).getFirstElement();
	}

}
