/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.workflow.mwe.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.mwe.ewm.workflow.Root;
import org.eclipse.emf.mwe.ewm.workflow.WorkflowFactory;
import org.eclipse.emf.mwe.ewm.workflow.WorkflowPackage;
import org.eclipse.emf.mwe.ewm.workflow.WorkflowParameter;
import org.eclipse.emf.mwe.ewm.workflow.WorkflowUnitOfWork;
import org.eclipse.emf.mwe.ewm.workflow.orchestration.OrchestrationFactory;
import org.eclipse.emf.mwe.ewm.workflow.runtime.RuntimeFactory;
import org.eclipse.emf.mwe.ewm.workflow.runtime.WorkflowContext;
import org.eclipse.emf.mwe.ewm.workflow.runtime.WorkflowEngine;
import org.eclipse.emf.mwe.ewm.workflow.runtime.WorkflowParameterMap;
import org.eclipse.gmt.modisco.workflow.WorkflowModelInterface;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.gmt.modisco.workflow.ui.common.MoDiscoWorkParameter;

public class WorkflowModelImpl implements WorkflowModelInterface {

	private Root root;
	private ResourceSet resSet;
	private Resource resource;
	private String currentPath;
	
	public WorkflowModelImpl() {
		// Obtain a new resource set
		this.resSet = new ResourceSetImpl();
	}
	
	public void addComponentWorkflow(String name, EObject modiscowork, List<MoDiscoWorkParameter> paramList) {
		
		WorkflowUnitOfWork component = WorkflowFactory.eINSTANCE.createWorkflowUnitOfWork();
		component.setName(name);
		component.setDescription("DESC_"+name);
		component.setType(name);
		component.setComponentOrchestrationStrategy(OrchestrationFactory.eINSTANCE.createWorkflowComponentOrchestrationStrategy());
		
		WorkflowParameter parameterMoDiscoWork = WorkflowFactory.eINSTANCE.createWorkflowParameter();
		parameterMoDiscoWork.setName("PARAMMODISCOWORK_"+name);
		parameterMoDiscoWork.setDescription("DESC_"+name);
		parameterMoDiscoWork.setType(modiscowork.eClass());
		parameterMoDiscoWork.setValueStrategy(WorkflowFactory.eINSTANCE.createWorkflowParameterValueStrategy());
		component.getParameters().add(parameterMoDiscoWork);
		
		WorkflowEngine engine  = RuntimeFactory.eINSTANCE.createWorkflowEngine();
		WorkflowContext context = RuntimeFactory.eINSTANCE.createWorkflowContext();
		
		//For modiscowork
		WorkflowParameterMap entryMap = (WorkflowParameterMap) RuntimeFactory.eINSTANCE.createWorkflowParameterMap();
		entryMap.setKey(parameterMoDiscoWork);
		entryMap.setValue(modiscowork);
		context.getParameters().add(entryMap);
		
		//Create all parameters and entyMap
		if(paramList!=null){
			for(MoDiscoWorkParameter parameter : paramList){
				WorkflowParameter param = WorkflowFactory.eINSTANCE.createWorkflowParameter();
				param.setName("PARAM_"+parameter.getName());
				param.setDescription("DESC_"+parameter.getDescription());
				param.setRequired(parameter.isRequired());
				param.setType(null);
				param.setValueStrategy(WorkflowFactory.eINSTANCE.createWorkflowParameterValueStrategy());
				component.getParameters().add(param);
				WorkflowParameterMap entry = (WorkflowParameterMap) RuntimeFactory.eINSTANCE.createWorkflowParameterMap();
				entry.setKey(param);
				entry.setValue(null);
				context.getParameters().add(entry);
			}
		}
		this.root.getComponents().add(component);
		
		engine.setContext(context);
		engine.setWorkflow(component);
		this.root.getEngines().add(engine);
		this.resource.getContents().add(this.root);
	}
	
	public void save(ILaunchConfigurationWorkingCopy configuration){
		// Now save the content.
		try {
			this.resource.save(Collections.EMPTY_MAP);
		} catch (IOException e) {
			e.printStackTrace();
		}
		
	}
	
	public List<EObject> getAllComponents() {
		List<EObject> listComponent = new ArrayList<EObject>();
		for(WorkflowEngine engine : this.root.getEngines()){
			listComponent.add(engine.getContext().getParameters().get(0).getValue());
		}
		return listComponent;
	}

	public void removeComponent(int index) {
		this.root.getComponents().remove(index);
		this.root.getEngines().remove(index);
		this.resource.getContents().add(this.root);	
	}

	public EObject getComponent(int index) {
		return this.root.getEngines().get(index).getContext().getParameters().get(0).getValue();
	}

	public void setComponent(int index, EObject parameter) {
		this.root.getEngines().get(index).getContext().getParameters().get(0).setValue(parameter);
		this.resource.getContents().add(this.root);
	}

	public void initialization(ILaunchConfiguration configuration, String path) {
		// Initialize the model
		WorkflowPackage.eINSTANCE.eClass();
		// Register the XMI resource factory for the .website extension
		Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
		Map<String, Object> m = reg.getExtensionToFactoryMap();
		m.put("workflow", new XMIResourceFactoryImpl());
		URI uri = URI.createFileURI(path);
		File f = new File(path);
		if(f.exists()){
			this.resource = this.resSet.getResource(uri, true);
			this.root = (Root) this.resource.getContents().get(0);		
		}else{
			this.root = WorkflowFactory.eINSTANCE.createRoot();
			this.resource = this.resSet.createResource(uri);
			this.resource.getContents().add(this.root);
		}
		this.currentPath = path; 
		save(null);
	}

	public void moveResource(String path) {
		if(!path.equals(this.currentPath)){
			URI uri = URI.createFileURI(path);
			this.resource.setURI(uri);
			save(null);
			File f = new File(this.currentPath);
			if(f.exists()){
				f.delete();
			}
			this.currentPath = path;
		}
	}
	
	public void removeResource(String resourcePath){
		if(resourcePath.equals(this.currentPath)){
			try {
				this.resource.delete(Collections.EMPTY_MAP);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
}
