/**
 * *******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sbastien Minguet (Mia-Software) - initial API and implementation
 *     Frdric Madiot (Mia-Software) - initial API and implementation
 *     Fabien Giquel (Mia-Software) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - initial API and implementation
 *     Erwan Breton (Sodifrance) - initial API and implementation
 * *******************************************************************************
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.j2se5;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Package Declaration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getQualifiedName <em>Qualified Name</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getOwnedElements <em>Owned Elements</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getModel <em>Model</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getOwnedPackages <em>Owned Packages</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getPackageDeclaration <em>Package Declaration</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getPackageDeclaration()
 * @model
 * @generated
 */
public interface PackageDeclaration extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Qualified Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Qualified Name</em>' attribute.
	 * @see #setQualifiedName(String)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getPackageDeclaration_QualifiedName()
	 * @model derived="true"
	 * @generated
	 */
	String getQualifiedName();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getQualifiedName <em>Qualified Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Qualified Name</em>' attribute.
	 * @see #getQualifiedName()
	 * @generated
	 */
	void setQualifiedName(String value);

	/**
	 * Returns the value of the '<em><b>Owned Elements</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.gmt.modisco.j2se5.AbstractTypeDeclaration}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.gmt.modisco.j2se5.AbstractTypeDeclaration#getPackage <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owned Elements</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Owned Elements</em>' containment reference list.
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getPackageDeclaration_OwnedElements()
	 * @see org.eclipse.gmt.modisco.j2se5.AbstractTypeDeclaration#getPackage
	 * @model opposite="package" containment="true"
	 * @generated
	 */
	EList<AbstractTypeDeclaration> getOwnedElements();

	/**
	 * Returns the value of the '<em><b>Model</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.gmt.modisco.j2se5.Model#getOwnedElements <em>Owned Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Model</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Model</em>' container reference.
	 * @see #setModel(Model)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getPackageDeclaration_Model()
	 * @see org.eclipse.gmt.modisco.j2se5.Model#getOwnedElements
	 * @model opposite="ownedElements" required="true"
	 * @generated
	 */
	Model getModel();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getModel <em>Model</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Model</em>' container reference.
	 * @see #getModel()
	 * @generated
	 */
	void setModel(Model value);

	/**
	 * Returns the value of the '<em><b>Owned Packages</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.gmt.modisco.j2se5.PackageDeclaration}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getPackageDeclaration <em>Package Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owned Packages</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Owned Packages</em>' containment reference list.
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getPackageDeclaration_OwnedPackages()
	 * @see org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getPackageDeclaration
	 * @model opposite="packageDeclaration" containment="true"
	 * @generated
	 */
	EList<PackageDeclaration> getOwnedPackages();

	/**
	 * Returns the value of the '<em><b>Package Declaration</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getOwnedPackages <em>Owned Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Package Declaration</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Package Declaration</em>' container reference.
	 * @see #setPackageDeclaration(PackageDeclaration)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getPackageDeclaration_PackageDeclaration()
	 * @see org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getOwnedPackages
	 * @model opposite="ownedPackages" required="true"
	 * @generated
	 */
	PackageDeclaration getPackageDeclaration();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.PackageDeclaration#getPackageDeclaration <em>Package Declaration</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Package Declaration</em>' container reference.
	 * @see #getPackageDeclaration()
	 * @generated
	 */
	void setPackageDeclaration(PackageDeclaration value);

} // PackageDeclaration
