/**
 * *******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sbastien Minguet (Mia-Software) - initial API and implementation
 *     Frdric Madiot (Mia-Software) - initial API and implementation
 *     Fabien Giquel (Mia-Software) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - initial API and implementation
 *     Erwan Breton (Sodifrance) - initial API and implementation
 * *******************************************************************************
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.j2se5.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.gmt.modisco.j2se5.ASTNode;
import org.eclipse.gmt.modisco.j2se5.Comment;
import org.eclipse.gmt.modisco.j2se5.CompilationUnit;
import org.eclipse.gmt.modisco.j2se5.J2se5Package;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>AST Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.ASTNodeImpl#getComments <em>Comments</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.ASTNodeImpl#getOriginalColumnNumber <em>Original Column Number</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.ASTNodeImpl#getOriginalLastLineNumber <em>Original Last Line Number</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.ASTNodeImpl#getOriginalLength <em>Original Length</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.ASTNodeImpl#getOriginalLineNumber <em>Original Line Number</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.ASTNodeImpl#getOriginalStartPosition <em>Original Start Position</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.ASTNodeImpl#getOriginalCompilationUnit <em>Original Compilation Unit</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class ASTNodeImpl extends EObjectImpl implements ASTNode {
	/**
	 * The cached value of the '{@link #getComments() <em>Comments</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComments()
	 * @generated
	 * @ordered
	 */
	protected EList<Comment> comments;

	/**
	 * The default value of the '{@link #getOriginalColumnNumber() <em>Original Column Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalColumnNumber()
	 * @generated
	 * @ordered
	 */
	protected static final int ORIGINAL_COLUMN_NUMBER_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getOriginalColumnNumber() <em>Original Column Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalColumnNumber()
	 * @generated
	 * @ordered
	 */
	protected int originalColumnNumber = ORIGINAL_COLUMN_NUMBER_EDEFAULT;

	/**
	 * The default value of the '{@link #getOriginalLastLineNumber() <em>Original Last Line Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalLastLineNumber()
	 * @generated
	 * @ordered
	 */
	protected static final int ORIGINAL_LAST_LINE_NUMBER_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getOriginalLastLineNumber() <em>Original Last Line Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalLastLineNumber()
	 * @generated
	 * @ordered
	 */
	protected int originalLastLineNumber = ORIGINAL_LAST_LINE_NUMBER_EDEFAULT;

	/**
	 * The default value of the '{@link #getOriginalLength() <em>Original Length</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalLength()
	 * @generated
	 * @ordered
	 */
	protected static final int ORIGINAL_LENGTH_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getOriginalLength() <em>Original Length</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalLength()
	 * @generated
	 * @ordered
	 */
	protected int originalLength = ORIGINAL_LENGTH_EDEFAULT;

	/**
	 * The default value of the '{@link #getOriginalLineNumber() <em>Original Line Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalLineNumber()
	 * @generated
	 * @ordered
	 */
	protected static final int ORIGINAL_LINE_NUMBER_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getOriginalLineNumber() <em>Original Line Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalLineNumber()
	 * @generated
	 * @ordered
	 */
	protected int originalLineNumber = ORIGINAL_LINE_NUMBER_EDEFAULT;

	/**
	 * The default value of the '{@link #getOriginalStartPosition() <em>Original Start Position</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalStartPosition()
	 * @generated
	 * @ordered
	 */
	protected static final int ORIGINAL_START_POSITION_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getOriginalStartPosition() <em>Original Start Position</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalStartPosition()
	 * @generated
	 * @ordered
	 */
	protected int originalStartPosition = ORIGINAL_START_POSITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOriginalCompilationUnit() <em>Original Compilation Unit</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginalCompilationUnit()
	 * @generated
	 * @ordered
	 */
	protected CompilationUnit originalCompilationUnit;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ASTNodeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return J2se5Package.Literals.AST_NODE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Comment> getComments() {
		if (comments == null) {
			comments = new EObjectContainmentEList<Comment>(Comment.class, this, J2se5Package.AST_NODE__COMMENTS);
		}
		return comments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getOriginalColumnNumber() {
		return originalColumnNumber;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOriginalColumnNumber(int newOriginalColumnNumber) {
		int oldOriginalColumnNumber = originalColumnNumber;
		originalColumnNumber = newOriginalColumnNumber;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.AST_NODE__ORIGINAL_COLUMN_NUMBER, oldOriginalColumnNumber, originalColumnNumber));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getOriginalLastLineNumber() {
		return originalLastLineNumber;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOriginalLastLineNumber(int newOriginalLastLineNumber) {
		int oldOriginalLastLineNumber = originalLastLineNumber;
		originalLastLineNumber = newOriginalLastLineNumber;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.AST_NODE__ORIGINAL_LAST_LINE_NUMBER, oldOriginalLastLineNumber, originalLastLineNumber));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getOriginalLength() {
		return originalLength;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOriginalLength(int newOriginalLength) {
		int oldOriginalLength = originalLength;
		originalLength = newOriginalLength;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.AST_NODE__ORIGINAL_LENGTH, oldOriginalLength, originalLength));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getOriginalLineNumber() {
		return originalLineNumber;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOriginalLineNumber(int newOriginalLineNumber) {
		int oldOriginalLineNumber = originalLineNumber;
		originalLineNumber = newOriginalLineNumber;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.AST_NODE__ORIGINAL_LINE_NUMBER, oldOriginalLineNumber, originalLineNumber));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getOriginalStartPosition() {
		return originalStartPosition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOriginalStartPosition(int newOriginalStartPosition) {
		int oldOriginalStartPosition = originalStartPosition;
		originalStartPosition = newOriginalStartPosition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.AST_NODE__ORIGINAL_START_POSITION, oldOriginalStartPosition, originalStartPosition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CompilationUnit getOriginalCompilationUnit() {
		if (originalCompilationUnit != null && originalCompilationUnit.eIsProxy()) {
			InternalEObject oldOriginalCompilationUnit = (InternalEObject)originalCompilationUnit;
			originalCompilationUnit = (CompilationUnit)eResolveProxy(oldOriginalCompilationUnit);
			if (originalCompilationUnit != oldOriginalCompilationUnit) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, J2se5Package.AST_NODE__ORIGINAL_COMPILATION_UNIT, oldOriginalCompilationUnit, originalCompilationUnit));
			}
		}
		return originalCompilationUnit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CompilationUnit basicGetOriginalCompilationUnit() {
		return originalCompilationUnit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOriginalCompilationUnit(CompilationUnit newOriginalCompilationUnit) {
		CompilationUnit oldOriginalCompilationUnit = originalCompilationUnit;
		originalCompilationUnit = newOriginalCompilationUnit;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.AST_NODE__ORIGINAL_COMPILATION_UNIT, oldOriginalCompilationUnit, originalCompilationUnit));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case J2se5Package.AST_NODE__COMMENTS:
				return ((InternalEList<?>)getComments()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case J2se5Package.AST_NODE__COMMENTS:
				return getComments();
			case J2se5Package.AST_NODE__ORIGINAL_COLUMN_NUMBER:
				return new Integer(getOriginalColumnNumber());
			case J2se5Package.AST_NODE__ORIGINAL_LAST_LINE_NUMBER:
				return new Integer(getOriginalLastLineNumber());
			case J2se5Package.AST_NODE__ORIGINAL_LENGTH:
				return new Integer(getOriginalLength());
			case J2se5Package.AST_NODE__ORIGINAL_LINE_NUMBER:
				return new Integer(getOriginalLineNumber());
			case J2se5Package.AST_NODE__ORIGINAL_START_POSITION:
				return new Integer(getOriginalStartPosition());
			case J2se5Package.AST_NODE__ORIGINAL_COMPILATION_UNIT:
				if (resolve) return getOriginalCompilationUnit();
				return basicGetOriginalCompilationUnit();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case J2se5Package.AST_NODE__COMMENTS:
				getComments().clear();
				getComments().addAll((Collection<? extends Comment>)newValue);
				return;
			case J2se5Package.AST_NODE__ORIGINAL_COLUMN_NUMBER:
				setOriginalColumnNumber(((Integer)newValue).intValue());
				return;
			case J2se5Package.AST_NODE__ORIGINAL_LAST_LINE_NUMBER:
				setOriginalLastLineNumber(((Integer)newValue).intValue());
				return;
			case J2se5Package.AST_NODE__ORIGINAL_LENGTH:
				setOriginalLength(((Integer)newValue).intValue());
				return;
			case J2se5Package.AST_NODE__ORIGINAL_LINE_NUMBER:
				setOriginalLineNumber(((Integer)newValue).intValue());
				return;
			case J2se5Package.AST_NODE__ORIGINAL_START_POSITION:
				setOriginalStartPosition(((Integer)newValue).intValue());
				return;
			case J2se5Package.AST_NODE__ORIGINAL_COMPILATION_UNIT:
				setOriginalCompilationUnit((CompilationUnit)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case J2se5Package.AST_NODE__COMMENTS:
				getComments().clear();
				return;
			case J2se5Package.AST_NODE__ORIGINAL_COLUMN_NUMBER:
				setOriginalColumnNumber(ORIGINAL_COLUMN_NUMBER_EDEFAULT);
				return;
			case J2se5Package.AST_NODE__ORIGINAL_LAST_LINE_NUMBER:
				setOriginalLastLineNumber(ORIGINAL_LAST_LINE_NUMBER_EDEFAULT);
				return;
			case J2se5Package.AST_NODE__ORIGINAL_LENGTH:
				setOriginalLength(ORIGINAL_LENGTH_EDEFAULT);
				return;
			case J2se5Package.AST_NODE__ORIGINAL_LINE_NUMBER:
				setOriginalLineNumber(ORIGINAL_LINE_NUMBER_EDEFAULT);
				return;
			case J2se5Package.AST_NODE__ORIGINAL_START_POSITION:
				setOriginalStartPosition(ORIGINAL_START_POSITION_EDEFAULT);
				return;
			case J2se5Package.AST_NODE__ORIGINAL_COMPILATION_UNIT:
				setOriginalCompilationUnit((CompilationUnit)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case J2se5Package.AST_NODE__COMMENTS:
				return comments != null && !comments.isEmpty();
			case J2se5Package.AST_NODE__ORIGINAL_COLUMN_NUMBER:
				return originalColumnNumber != ORIGINAL_COLUMN_NUMBER_EDEFAULT;
			case J2se5Package.AST_NODE__ORIGINAL_LAST_LINE_NUMBER:
				return originalLastLineNumber != ORIGINAL_LAST_LINE_NUMBER_EDEFAULT;
			case J2se5Package.AST_NODE__ORIGINAL_LENGTH:
				return originalLength != ORIGINAL_LENGTH_EDEFAULT;
			case J2se5Package.AST_NODE__ORIGINAL_LINE_NUMBER:
				return originalLineNumber != ORIGINAL_LINE_NUMBER_EDEFAULT;
			case J2se5Package.AST_NODE__ORIGINAL_START_POSITION:
				return originalStartPosition != ORIGINAL_START_POSITION_EDEFAULT;
			case J2se5Package.AST_NODE__ORIGINAL_COMPILATION_UNIT:
				return originalCompilationUnit != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (originalColumnNumber: ");
		result.append(originalColumnNumber);
		result.append(", originalLastLineNumber: ");
		result.append(originalLastLineNumber);
		result.append(", originalLength: ");
		result.append(originalLength);
		result.append(", originalLineNumber: ");
		result.append(originalLineNumber);
		result.append(", originalStartPosition: ");
		result.append(originalStartPosition);
		result.append(')');
		return result.toString();
	}

} //ASTNodeImpl
