/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.discoverersmanager.ui.actions;

import java.util.ArrayList;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoverersManager;
import org.eclipse.gmt.modisco.discoverersmanager.handlers.DiscovererHandler;
import org.eclipse.gmt.modisco.discoverersmanager.ui.actions.MenuListenerHandler;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;

public class ContributionItemForMoDiscoMenu
extends ContributionItem {
    public void fill(Menu menu, int index) {
        super.fill(menu, index);
        ArrayList<DiscovererHandler> discoverers = new ArrayList<DiscovererHandler>();
        try {
            IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)menu.getShell().getData();
            ISelectionService selectionService = workbenchWindow.getSelectionService();
            if (selectionService.getSelection() != null && selectionService.getSelection() instanceof IStructuredSelection && !selectionService.getSelection().isEmpty()) {
                IStructuredSelection selection = (IStructuredSelection)selectionService.getSelection();
                Object[] selectedObjects = selection.toArray();
                for (DiscovererHandler discoverer : DiscoverersManager.getDefault().getDiscovererHandlers()) {
                    boolean applyTo = true;
                    int i = 0;
                    while (applyTo && i < selectedObjects.length) {
                        Object selectedObject = selectedObjects[i];
                        applyTo = discoverer.isApplicableTo(selectedObject);
                        ++i;
                    }
                    if (!applyTo) continue;
                    discoverers.add(discoverer);
                }
                if (discoverers.size() > 0) {
                    MenuItem modiscoItem = new MenuItem(menu, 64, index);
                    modiscoItem.setText("MoDisco");
                    Image image = null;
                    ImageDescriptor descriptor = DiscoverersManager.getImageDescriptor("logoMoDiscoMini.gif");
                    if (descriptor != null) {
                        image = descriptor.createImage();
                        modiscoItem.setImage(image);
                    }
                    Menu modiscoMenu = new Menu(modiscoItem);
                    modiscoItem.setMenu(modiscoMenu);
                    for (DiscovererHandler discoverer : discoverers) {
                        Menu parentMenu = modiscoMenu;
                        if (discoverer.getPaths() != null && discoverer.getPaths().length > 0) {
                            String[] stringArray = discoverer.getPaths();
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String pathEntry = stringArray[n2];
                                MenuItem intermediateMenu = null;
                                MenuItem[] menuItemArray = parentMenu.getItems();
                                int n3 = menuItemArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    MenuItem item = menuItemArray[n4];
                                    if (item.getText().equalsIgnoreCase(pathEntry)) {
                                        intermediateMenu = item;
                                    }
                                    ++n4;
                                }
                                if (intermediateMenu == null) {
                                    intermediateMenu = new MenuItem(parentMenu, 64, parentMenu.getItemCount());
                                    intermediateMenu.setText(pathEntry);
                                    parentMenu = new Menu(intermediateMenu);
                                    intermediateMenu.setMenu(parentMenu);
                                } else {
                                    parentMenu = intermediateMenu.getMenu();
                                }
                                ++n2;
                            }
                        }
                        MenuItem discovererMenu = new MenuItem(parentMenu, 8, 0);
                        discovererMenu.setText(discoverer.getName());
                        discovererMenu.setImage(image);
                        MenuListenerHandler handler = new MenuListenerHandler(discoverer, selectedObjects, null);
                        discovererMenu.addSelectionListener((SelectionListener)handler);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isDynamic() {
        return true;
    }
}

