/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.core.examples;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.core.service.LauncherService;
import org.eclipse.m2m.atl.core.ui.vm.asm.ASMModelWrapper;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class AtlTransformation {
    private final String kdmMMUri = "http://www.eclipse.org/MoDisco/kdm/action";
    private final String j2se5MMUri = "http://www.eclipse.org/MoDisco/J2SE5";
    public static final String TEST_IN_MODEL = "platform:/resource/test/test.in";
    private Resource resourceTemp;

    public Resource testDetaillePourRegularVm(URI j2se5SourceModelUri, final URL transformation, URI kdmTargetModelUri) throws ATLCoreException {
        ASMModelWrapper wrapper;
        ASMModel model;
        HashMap<String, String> modelHandlers = new HashMap<String, String>();
        String j2se5MetaModelName = "j2se5";
        modelHandlers.put(j2se5MetaModelName, "EMF");
        String kdmMetaModelName = "kdm";
        modelHandlers.put(kdmMetaModelName, "EMF");
        HashMap<String, HashMap<String, String>> launcherOptions = new HashMap<String, HashMap<String, String>>();
        launcherOptions.put("modelHandlers", modelHandlers);
        String launcherName = "Regular VM (with debugger)";
        final ILauncher launcher = CoreService.getLauncher((String)launcherName);
        launcher.initialize(launcherOptions);
        ModelFactory factory = CoreService.createModelFactory((String)launcher.getDefaultModelFactoryName());
        IInjector injector = CoreService.getInjector((String)factory.getDefaultInjectorName());
        IExtractor extractor = CoreService.getExtractor((String)factory.getDefaultExtractorName());
        HashMap referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(j2se5MetaModelName));
        referenceModelOptions.put("modelName", j2se5MetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/MoDisco/J2SE5");
        IReferenceModel j2se5MM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)j2se5MM, "http://www.eclipse.org/MoDisco/J2SE5");
        HashMap<String, Object> modelOptions = new HashMap<String, Object>();
        String inModelName = "IN";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", j2se5SourceModelUri.toString());
        modelOptions.put("newModel", false);
        IModel input = factory.newModel(j2se5MM, modelOptions);
        injector.inject(input, j2se5SourceModelUri.toString());
        launcher.addInModel(input, inModelName, j2se5MetaModelName);
        referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(kdmMetaModelName));
        referenceModelOptions.put("modelName", kdmMetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/MoDisco/kdm/action");
        IReferenceModel kdmMM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)kdmMM, "http://www.eclipse.org/MoDisco/kdm/action");
        modelOptions = new HashMap();
        inModelName = "OUT";
        modelOptions.put("modelName", inModelName);
        if (kdmTargetModelUri != null) {
            modelOptions.put("path", kdmTargetModelUri.toString());
        } else {
            modelOptions.put("path", j2se5SourceModelUri.trimFileExtension().appendFileExtension("kdm").toString());
        }
        modelOptions.put("newModel", true);
        IModel outputInstance = factory.newModel(kdmMM, modelOptions);
        launcher.addOutModel(outputInstance, inModelName, kdmMetaModelName);
        final HashMap<String, String> options = new HashMap<String, String>();
        options.put("continueAfterError", "true");
        options.put("printExecutionTime", "true");
        Job transformationThread = new Job("Convert J2SE5 model to KDM"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    launcher.launch("run", monitor, options, new Object[]{transformation.openStream()});
                }
                catch (IOException e) {
                    result = Status.CANCEL_STATUS;
                    e.printStackTrace();
                }
                return result;
            }
        };
        transformationThread.schedule();
        try {
            transformationThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (kdmTargetModelUri != null) {
            extractor.extract(outputInstance, kdmTargetModelUri.toString());
        }
        Resource output = null;
        if (outputInstance instanceof ASMModelWrapper && (model = (wrapper = (ASMModelWrapper)outputInstance).getAsmModel()) instanceof ASMEMFModel) {
            output = ((ASMEMFModel)model).getExtent();
        }
        return output;
    }

    public Resource testSimplifieUtilisantLauncherServicePourRegularVm(URI j2se5SourceModelUri, final URL transformation, URI kdmTargetModelUri) throws ATLCoreException {
        HashMap<String, String> modelHandlers = new HashMap<String, String>();
        String j2se5MetaModelName = "j2se5";
        modelHandlers.put(j2se5MetaModelName, "EMF");
        String kdmMetaModelName = "kdm";
        modelHandlers.put(kdmMetaModelName, "EMF");
        final HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("modelHandlers", modelHandlers);
        String launcherName = "Regular VM (with debugger)";
        final ILauncher launcher = CoreService.getLauncher((String)launcherName);
        launcher.initialize(options);
        final HashMap<String, String> sourceModels = new HashMap<String, String>();
        sourceModels.put("IN", "j2se5");
        final HashMap<String, String> targetModels = new HashMap<String, String>();
        targetModels.put("OUT", "kdm");
        final HashMap<String, String> modelPaths = new HashMap<String, String>();
        modelPaths.put("j2se5", "http://www.eclipse.org/MoDisco/J2SE5");
        modelPaths.put("IN", j2se5SourceModelUri.toString());
        modelPaths.put("kdm", "http://www.eclipse.org/MoDisco/kdm/action");
        if (kdmTargetModelUri != null) {
            modelPaths.put("OUT", kdmTargetModelUri.toString());
        } else {
            modelPaths.put("OUT", j2se5SourceModelUri.trimFileExtension().appendFileExtension("kdm").toString());
        }
        options.put("continueAfterError", "true");
        options.put("printExecutionTime", "true");
        Job transformationThread = new Job("Convert J2SE5 model to KDM"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    ASMModelWrapper wrapper;
                    ASMModel model;
                    InputStream[] modules = new InputStream[]{transformation.openStream()};
                    Map libraries = Collections.emptyMap();
                    Object resultModel = LauncherService.launch((String)"run", (IProgressMonitor)monitor, (ILauncher)launcher, (Map)sourceModels, (Map)Collections.EMPTY_MAP, (Map)targetModels, (Map)modelPaths, (Map)options, libraries, (InputStream[])modules);
                    if (resultModel instanceof ASMModelWrapper && (model = (wrapper = (ASMModelWrapper)resultModel).getAsmModel()) instanceof ASMEMFModel) {
                        AtlTransformation.this.resourceTemp = ((ASMEMFModel)model).getExtent();
                    }
                }
                catch (IOException e) {
                    result = Status.CANCEL_STATUS;
                    e.printStackTrace();
                }
                catch (ATLCoreException e) {
                    result = Status.CANCEL_STATUS;
                    e.printStackTrace();
                }
                return result;
            }
        };
        transformationThread.schedule();
        try {
            transformationThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Resource output = this.resourceTemp;
        return output;
    }

    public void testDetaillePourEmfVm(URL asmURL, IFile file) throws ATLCoreException, IOException {
        ILauncher launcher = null;
        launcher = CoreService.getLauncher((String)"EMF-specific VM");
        launcher.initialize(Collections.emptyMap());
        ModelFactory factory = CoreService.createModelFactory((String)launcher.getDefaultModelFactoryName());
        IInjector injector = CoreService.getInjector((String)factory.getDefaultInjectorName());
        IExtractor extractor = CoreService.getExtractor((String)factory.getDefaultExtractorName());
        IReferenceModel umlMetamodel = factory.newReferenceModel();
        injector.inject((IModel)umlMetamodel, "http://www.eclipse.org/uml2/2.1.0/UML");
        IReferenceModel refiningTraceMetamodel = factory.getBuiltInResource("RefiningTrace.ecore");
        IModel refiningTraceModel = factory.newModel(refiningTraceMetamodel);
        IModel umlModel = factory.newModel(umlMetamodel);
        injector.inject(umlModel, file.getFullPath().toString());
        launcher.addOutModel(refiningTraceModel, "refiningTrace", "RefiningTrace");
        launcher.addInOutModel(umlModel, "IN", "UML");
        launcher.launch("run", (IProgressMonitor)new NullProgressMonitor(), Collections.emptyMap(), new Object[]{asmURL.openStream()});
        extractor.extract(umlModel, file.getFullPath().toString());
    }
}

