/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationWrapper;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.gmt.modisco.common.editor.adapters.BigListItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.MiaReflectiveItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.TransientItemProvider;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.util.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkItemProvider
extends TransientItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider {
    protected EReference reference;
    protected EObject parent;
    protected final EditorConfiguration editorConfiguration;

    public LinkItemProvider(AdapterFactory adapterFactory, EObject parent, EReference reference, EditorConfiguration editorConfiguration) {
        super(adapterFactory, parent);
        this.reference = reference;
        this.parent = parent;
        this.editorConfiguration = editorConfiguration;
        parent.eAdapters().add((Object)this);
    }

    public EReference getReference() {
        return this.reference;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(this.reference);
        }
        return this.childrenFeatures;
    }

    public void notifyChanged(Notification notification) {
        if (this.reference == notification.getFeature()) {
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)this.parent, false, true));
            if (notification.getEventType() == 1) {
                this.fireNotifyChanged((Notification)new NotificationWrapper((Object)this, notification));
            }
        }
    }

    public int getCount() {
        Object ref = this.parent.eGet((EStructuralFeature)this.reference);
        int count = this.reference.isMany() ? ((List)ref).size() : (ref != null ? 1 : 0);
        return count;
    }

    public String getText(Object object) {
        EReference oppositeRef;
        String multiplicity = "";
        if (this.editorConfiguration.isShowMultiplicity()) {
            multiplicity = LinkItemProvider.getMultiplicity(this.reference);
        }
        String opposite = "";
        if (this.editorConfiguration.isShowOppositeLinks() && (oppositeRef = this.reference.getEOpposite()) != null) {
            String oppositeMultiplicity = "";
            if (this.editorConfiguration.isShowMultiplicity()) {
                oppositeMultiplicity = LinkItemProvider.getMultiplicity(oppositeRef);
            }
            opposite = " <-> " + oppositeRef.getName() + oppositeMultiplicity;
        }
        String prefix = this.reference.isDerived() ? "/" : "";
        return String.valueOf(prefix) + this.reference.getName() + multiplicity + opposite + " (" + this.getCount() + ")";
    }

    public static String getMultiplicity(EReference reference) {
        String multLow = reference.isRequired() ? "1" : "0";
        String multHigh = reference.isMany() ? "*" : "1";
        return " [" + multLow + ".." + multHigh + "]";
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        if (!this.reference.isContainment()) {
            return;
        }
        Collection<EClass> allClasses = this.editorConfiguration.getAllClasses();
        EFactory factory = this.reference.getEReferenceType().getEPackage().getEFactoryInstance();
        EClass referenceType = this.reference.getEReferenceType();
        for (EClass aClass : allClasses) {
            if (aClass.isAbstract() || !referenceType.isSuperTypeOf(aClass)) continue;
            try {
                EObject newInstance = factory.create(aClass);
                newChildDescriptors.add(this.createChildParameter(this.reference, newInstance));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        if (new AddCommand(domain, (EObject)owner, (EStructuralFeature)this.reference, collection).canExecute()) {
            return super.createDragAndDropCommand(domain, owner, location, operations, operation, collection);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Object getImage(Object object) {
        return LinkItemProvider.getImageFor(this.reference);
    }

    public static Object getImageFor(EReference reference) {
        EReference opposite = reference.getEOpposite();
        if (reference.isContainment()) {
            if (opposite == null) {
                return ImageProvider.getInstance().getUnidirectionalAggregIcon();
            }
            return ImageProvider.getInstance().getAggregIcon();
        }
        if (opposite != null && opposite.isContainment()) {
            return ImageProvider.getInstance().getInvAggregIcon();
        }
        if (opposite == null) {
            return ImageProvider.getInstance().getUnidirectionalLinkIcon();
        }
        return ImageProvider.getInstance().getLinkIcon();
    }

    @Override
    public Object getParent(Object object) {
        return this.parent;
    }

    @Override
    public Collection<?> getChildren(Object object) {
        Collection<?> children = super.getChildren(this.parent);
        ArrayList<EObject> childrenList = new ArrayList<EObject>();
        childrenList.addAll(children);
        return BigListItemProvider.splitElements((Object)this, this.parent, childrenList, this.adapterFactory, this.editorConfiguration, null);
    }

    public Collection<EObject> getChildrenElements() {
        Collection<EObject> children = super.getChildren(this.parent);
        return children;
    }

    protected String getFeatureText(Object feature) {
        return this.reference.getName();
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            this.itemPropertyDescriptors = new ArrayList();
            MiaReflectiveItemProvider parentItemProvider = (MiaReflectiveItemProvider)this.adapterFactory.adapt((Notifier)this.parent, IItemPropertySource.class);
            List parentDescriptors = parentItemProvider.getPropertyDescriptors(this.parent);
            for (IItemPropertyDescriptor descriptor : parentDescriptors) {
                if (descriptor.getFeature((Object)this.parent) != this.reference) continue;
                this.itemPropertyDescriptors.add(new ItemPropertyDescriptorDecorator(this.parent, descriptor){

                    public String getCategory(Object thisObject) {
                        return null;
                    }

                    public String getId(Object thisObject) {
                        return String.valueOf(LinkItemProvider.this.reference.getName()) + this.getDisplayName(thisObject);
                    }
                });
            }
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        if (sibling instanceof BigListItemProvider) {
            return Collections.emptyList();
        }
        return super.getNewChildDescriptors(object, editingDomain, sibling);
    }

    public Object getForeground(Object object) {
        if (this.getCount() == 0) {
            return IItemColorProvider.GRAYED_OUT_COLOR;
        }
        return super.getForeground(object);
    }

    public Object getCreateChildImage(Object owner, Object feature, Object child, Collection<?> selection) {
        return null;
    }
}

