/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.gmt.modisco.common.editor.adapters.BigListItemProvider;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclasses;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaclassInstancesItemProvider
extends ItemProviderAdapter
implements IStructuredItemContentProvider,
IItemLabelProvider,
IEditingDomainItemProvider {
    private final EditorConfiguration editorConfiguration;
    private final String[] metaclasses;
    private InstancesForMetaclasses.ModelChangeListener modelChangeListener;
    private Collection<?> cachedElements = null;
    private boolean dirty;
    private boolean oldSortInstances;

    public MetaclassInstancesItemProvider(AdapterFactory adapterFactory, EditorConfiguration editorConfiguration, String[] metaclasses) {
        super(adapterFactory);
        this.editorConfiguration = editorConfiguration;
        this.metaclasses = metaclasses;
        InstancesForMetaclasses instancesForMetaclasses = this.editorConfiguration.getInstancesForMetaclasses();
        this.modelChangeListener = new InstancesForMetaclasses.ModelChangeListener(){

            public void modelChanged() {
                MetaclassInstancesItemProvider.this.markDirty();
            }

            public void removedLastInstanceof(String metaclassQualifiedName) {
            }
        };
        instancesForMetaclasses.addListener(this.modelChangeListener);
    }

    public void dispose() {
        this.editorConfiguration.getInstancesForMetaclasses().removeListener(this.modelChangeListener);
    }

    private void markDirty() {
        this.dirty = true;
    }

    public Collection<?> getElements(Object object) {
        if (this.editorConfiguration.isSortInstances() != this.oldSortInstances) {
            this.markDirty();
        }
        this.oldSortInstances = this.editorConfiguration.isSortInstances();
        if (this.cachedElements == null || this.dirty) {
            ArrayList<EObject> allElements = new ArrayList<EObject>();
            InstancesForMetaclasses instancesForMetaclasses = this.editorConfiguration.getInstancesForMetaclasses();
            String[] stringArray = this.metaclasses;
            int n = this.metaclasses.length;
            int n2 = 0;
            while (n2 < n) {
                String metaclassQualifiedName = stringArray[n2];
                InstancesForMetaclass instancesForMetaclass = instancesForMetaclasses.getInstancesForMetaclass(metaclassQualifiedName);
                ArrayList<EObject> elements = instancesForMetaclass.getElements();
                allElements.addAll(elements);
                if (this.editorConfiguration.isDisplayInstancesOfSubclasses()) {
                    allElements.addAll(instancesForMetaclass.getDerivedElements());
                }
                ++n2;
            }
            this.cachedElements = BigListItemProvider.splitElements((Object)this, null, allElements, this.adapterFactory, this.editorConfiguration, this.cachedElements);
            this.dirty = false;
        }
        return this.cachedElements;
    }

    public Object getImage(Object object) {
        return null;
    }

    public String getText(Object object) {
        return "Instances";
    }

    public Command createCommand(Object object, EditingDomain domain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        EObject owner = null;
        EStructuralFeature containingFeature = null;
        Collection collection = commandParameter.getCollection();
        for (Object o : collection) {
            if (!(o instanceof EObject)) continue;
            EObject eObject = (EObject)o;
            if (owner != null && owner != eObject.eContainer() || containingFeature != null && containingFeature != eObject.eContainingFeature()) {
                return UnexecutableCommand.INSTANCE;
            }
            owner = eObject.eContainer();
            containingFeature = eObject.eContainingFeature();
        }
        if (owner == null || containingFeature == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (commandClass == RemoveCommand.class && !containingFeature.isMany()) {
            return new SetCommand(domain, owner, containingFeature, commandParameter.value);
        }
        commandParameter.setOwner(owner);
        commandParameter.feature = containingFeature;
        return super.createCommand((Object)owner, domain, commandClass, commandParameter);
    }

    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        return Collections.emptyList();
    }

    public Collection<?> getChildren(Object object) {
        return Collections.emptyList();
    }

    public Object getParent(Object object) {
        return null;
    }
}

