/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.core;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclasses;
import org.eclipse.gmt.modisco.common.editor.util.EMFUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstancesForMetaclass
extends AdapterImpl {
    private ArrayList<EObject> elements = new ArrayList();
    private ArrayList<EObject> derivedElements = new ArrayList();
    private ArrayList<InstancesForMetaclass> subclasses = new ArrayList();
    private final EClass eClass;
    private final InstancesForMetaclasses instancesForMetaclasses;
    private ChangeListener listener = null;
    private String classQualifiedName = null;
    private Object parent;

    public InstancesForMetaclass(EClass eClass, InstancesForMetaclasses instancesForMetaclasses) {
        this.eClass = eClass;
        this.instancesForMetaclasses = instancesForMetaclasses;
    }

    public ArrayList<EObject> getElements() {
        return this.elements;
    }

    public ArrayList<EObject> getDerivedElements() {
        return this.derivedElements;
    }

    public void add(EObject object) {
        object.eAdapters().add((Object)this);
        this.elements.add(object);
        this.addDerived(object);
    }

    private void addDerived(EObject object) {
        EList allSuperTypes = this.eClass.getEAllSuperTypes();
        for (EClass superclass : allSuperTypes) {
            InstancesForMetaclass instancesForSuperclass = this.instancesForMetaclasses.getInstancesForMetaclass(EMFUtil.getMetaclassQualifiedName(superclass));
            if (instancesForSuperclass != null) {
                instancesForSuperclass.derivedElements.add(object);
                continue;
            }
            MoDiscoEditorPlugin.INSTANCE.log(String.valueOf(EMFUtil.getMetaclassQualifiedName(superclass)) + " not found");
        }
    }

    public void remove(EObject object) {
        object.eAdapters().remove((Object)this);
        this.elements.remove(object);
        this.removeDerived(object, false);
    }

    private void removeDerived(EObject object, boolean derived) {
        if (derived) {
            this.derivedElements.remove(object);
        }
        EList allSuperTypes = this.eClass.getEAllSuperTypes();
        for (EClass superclass : allSuperTypes) {
            InstancesForMetaclass instancesForSuperclass = this.instancesForMetaclasses.getInstancesForMetaclass(EMFUtil.getMetaclassQualifiedName(superclass));
            instancesForSuperclass.removeDerived(object, true);
        }
    }

    public void setListener(ChangeListener listener) {
        this.listener = listener;
    }

    public void notifyChanged(Notification msg) {
        super.notifyChanged(msg);
        this.fireNotifyChanged(msg);
    }

    public int size() {
        return this.elements.size();
    }

    public int totalSize() {
        return this.elements.size() + this.derivedElements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public String getClassQualifiedName() {
        if (this.classQualifiedName == null) {
            this.classQualifiedName = EMFUtil.getMetaclassQualifiedName(this.getEClass());
        }
        return this.classQualifiedName;
    }

    private void fireNotifyChanged(Notification msg) {
        if (this.listener != null) {
            this.listener.notifyChanged(msg);
        }
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Object getParent() {
        return this.parent;
    }

    public void buildParentsSubclasses() {
        EList superTypes = this.eClass.getESuperTypes();
        for (EClass superclass : superTypes) {
            InstancesForMetaclass instancesForSuperclass = this.instancesForMetaclasses.getInstancesForMetaclass(EMFUtil.getMetaclassQualifiedName(superclass));
            if (instancesForSuperclass != null) {
                instancesForSuperclass.addSubclass(this);
                continue;
            }
            MoDiscoEditorPlugin.INSTANCE.log(String.valueOf(EMFUtil.getMetaclassQualifiedName(superclass)) + " not found");
        }
    }

    public void clearSubclasses() {
        this.subclasses.clear();
    }

    public InstancesForMetaclass[] getSubclasses() {
        return this.subclasses.toArray(new InstancesForMetaclass[this.subclasses.size()]);
    }

    private void addSubclass(InstancesForMetaclass instancesForMetaclass) {
        this.subclasses.add(instancesForMetaclass);
    }

    public static interface ChangeListener {
        public void notifyChanged(Notification var1);
    }
}

