/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.common.editor.util.EMFUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstancesForMetaclasses
implements InstancesForMetaclass.ChangeListener {
    private TreeMap<String, InstancesForMetaclass> modelElements = new TreeMap();
    private ArrayList<InstancesForMetaclass> rootMetaclasses = new ArrayList();
    private ArrayList<ModelChangeListener> listeners = new ArrayList();

    public InstancesForMetaclass[] getInstancesForMetaclasses() {
        Collection<InstancesForMetaclass> instancesForMetaclasses = this.modelElements.values();
        return instancesForMetaclasses.toArray(new InstancesForMetaclass[instancesForMetaclasses.size()]);
    }

    public InstancesForMetaclass getInstancesForMetaclass(String metaclassQualifiedName) {
        return this.modelElements.get(metaclassQualifiedName);
    }

    public void initModel(ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        if (resources.size() == 0) {
            return;
        }
        Resource resource = (Resource)resources.get(0);
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            this.addModelElement(eObject, false);
        }
    }

    private void addModelElement(EObject element, boolean recursively) {
        String classQualifiedName = EMFUtil.getMetaclassQualifiedName(element.eClass());
        InstancesForMetaclass instancesForMetaclass = this.modelElements.get(classQualifiedName);
        if (instancesForMetaclass == null) {
            instancesForMetaclass = new InstancesForMetaclass(element.eClass(), this);
            instancesForMetaclass.setListener(this);
            this.modelElements.put(classQualifiedName, instancesForMetaclass);
        }
        instancesForMetaclass.add(element);
        this.fireModelChanged();
        if (recursively) {
            EList contents = element.eContents();
            for (EObject contained : contents) {
                this.addModelElement(contained, true);
            }
        }
    }

    private void removeModelElement(EObject element) {
        String classQualifiedName = EMFUtil.getMetaclassQualifiedName(element.eClass());
        InstancesForMetaclass instancesForMetaclass = this.modelElements.get(classQualifiedName);
        if (instancesForMetaclass != null) {
            instancesForMetaclass.remove(element);
            this.fireModelChanged();
            if (instancesForMetaclass.isEmpty()) {
                this.fireRemovedLastInstanceof(classQualifiedName);
            }
        }
        EList contents = element.eContents();
        for (EObject contained : contents) {
            this.removeModelElement(contained);
        }
    }

    public void addListener(ModelChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ModelChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyChanged(Notification msg) {
        int eventType = msg.getEventType();
        switch (eventType) {
            case 3: {
                EReference feature;
                Object featureObj = msg.getFeature();
                if (featureObj instanceof EReference && !(feature = (EReference)featureObj).isContainment()) {
                    return;
                }
                Object newValue = msg.getNewValue();
                if (!(newValue instanceof EObject)) break;
                this.addModelElement((EObject)newValue, true);
                break;
            }
            case 4: {
                EReference feature;
                Object featureObj = msg.getFeature();
                if (featureObj instanceof EReference && !(feature = (EReference)featureObj).isContainment()) {
                    return;
                }
                Object oldValue = msg.getOldValue();
                if (!(oldValue instanceof EObject)) break;
                this.removeModelElement((EObject)oldValue);
                break;
            }
            case 5: {
                Object newValue = msg.getNewValue();
                if (!(newValue instanceof EList)) break;
                EList eList = (EList)newValue;
                for (Object object : eList) {
                    if (!(object instanceof EObject)) continue;
                    this.addModelElement((EObject)object, true);
                }
                break;
            }
            case 6: {
                Object newValue = msg.getNewValue();
                if (!(newValue instanceof EList)) break;
                EList eList = (EList)newValue;
                for (Object object : eList) {
                    if (!(object instanceof EObject)) continue;
                    this.removeModelElement((EObject)object);
                }
                break;
            }
            case 1: {
                EReference reference;
                Object newValue = msg.getNewValue();
                Object feature = msg.getFeature();
                if (!(feature instanceof EReference) || !(reference = (EReference)feature).isContainment()) break;
                if (newValue == null) {
                    Object oldValue = msg.getOldValue();
                    if (!(oldValue instanceof EObject)) break;
                    this.removeModelElement((EObject)oldValue);
                    break;
                }
                if (!(newValue instanceof EObject)) break;
                this.addModelElement((EObject)newValue, true);
                break;
            }
            case 2: {
                EReference reference;
                Object oldValue = msg.getOldValue();
                Object feature = msg.getFeature();
                if (feature instanceof EReference && !(reference = (EReference)feature).isContainment()) break;
                if (oldValue instanceof EObject) {
                    this.removeModelElement((EObject)oldValue);
                }
                this.fireModelChanged();
            }
        }
    }

    private void fireModelChanged() {
        for (ModelChangeListener listener : this.listeners) {
            listener.modelChanged();
        }
    }

    private void fireRemovedLastInstanceof(String metaclassQualifiedName) {
        for (ModelChangeListener listener : this.listeners) {
            listener.removedLastInstanceof(metaclassQualifiedName);
        }
    }

    public void addMetaclasses(Collection<EClass> metaclasses) {
        for (EClass eClass : metaclasses) {
            String metaclassQualifiedName = EMFUtil.getMetaclassQualifiedName(eClass);
            if (this.modelElements.get(metaclassQualifiedName) != null) continue;
            InstancesForMetaclass instancesForMetaclass = new InstancesForMetaclass(eClass, this);
            instancesForMetaclass.setListener(this);
            this.modelElements.put(metaclassQualifiedName, instancesForMetaclass);
        }
    }

    public void buildDerivationTree() {
        InstancesForMetaclass instancesForMetaclass;
        InstancesForMetaclass[] instancesByMetaclass = this.getInstancesForMetaclasses();
        this.rootMetaclasses.clear();
        InstancesForMetaclass[] instancesForMetaclassArray = instancesByMetaclass;
        int n = instancesByMetaclass.length;
        int n2 = 0;
        while (n2 < n) {
            instancesForMetaclass = instancesForMetaclassArray[n2];
            instancesForMetaclass.clearSubclasses();
            ++n2;
        }
        instancesForMetaclassArray = instancesByMetaclass;
        n = instancesByMetaclass.length;
        n2 = 0;
        while (n2 < n) {
            instancesForMetaclass = instancesForMetaclassArray[n2];
            instancesForMetaclass.buildParentsSubclasses();
            if (instancesForMetaclass.getEClass().getESuperTypes().isEmpty()) {
                this.rootMetaclasses.add(instancesForMetaclass);
            }
            ++n2;
        }
    }

    public InstancesForMetaclass[] getRootMetaclasses() {
        return this.rootMetaclasses.toArray(new InstancesForMetaclass[this.rootMetaclasses.size()]);
    }

    public static interface ModelChangeListener {
        public void modelChanged();

        public void removedLastInstanceof(String var1);
    }
}

