/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.common.editor.adapters.LinkItemProvider;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CustomTreePainter
implements PropertyChangeListener {
    private Font arrowFont;
    private final Tree tree;
    private int baseHeight;
    private int currentFontSize;
    private final EditorConfiguration editorConfiguration;

    public CustomTreePainter(Tree tree, EditorConfiguration editorConfiguration) {
        this.tree = tree;
        this.editorConfiguration = editorConfiguration;
        this.baseHeight = JFaceResources.getDialogFont().getFontData()[0].getHeight();
        editorConfiguration.addPropertyChangeListener(this);
        this.configureFont(editorConfiguration.getFontSizeDelta());
        this.setupTreeCustomPaint(tree);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("fontSizeDelta".equals(event.getPropertyName())) {
            this.configureFont((Integer)event.getNewValue());
        }
    }

    private void configureFont(int fontDelta) {
        this.currentFontSize = this.baseHeight + fontDelta;
        if (this.arrowFont != null) {
            this.arrowFont.dispose();
        }
        this.arrowFont = new Font((Device)this.tree.getDisplay(), "Wingdings", this.currentFontSize, 0);
    }

    private boolean isOrderedReference(Object object) {
        if (this.editorConfiguration.isSortInstances()) {
            return false;
        }
        if (object instanceof LinkItemProvider) {
            LinkItemProvider linkItemProvider = (LinkItemProvider)((Object)object);
            EReference reference = linkItemProvider.getReference();
            return reference.isMany() && reference.isOrdered();
        }
        return false;
    }

    private boolean isEnabled() {
        return this.editorConfiguration.isShowOrdering();
    }

    private void handleMeasureItem(Event event) {
        if (this.isEnabled()) {
            int order;
            TreeItem item = (TreeItem)event.item;
            Object data = item.getData();
            if (this.isOrderedReference(data)) {
                event.width += this.currentFontSize;
            } else if (data instanceof EObject && (order = this.findElementOrder(item)) != -1) {
                event.width += event.gc.textExtent((String)this.orderStringFor((int)order)).x + 3;
            }
        }
    }

    private void handlePaintItem(Event event) {
        if (this.isEnabled()) {
            int order;
            TreeItem item = (TreeItem)event.item;
            Object data = item.getData();
            if (this.isOrderedReference(data)) {
                this.paintOrderArrow(event);
            } else if (data instanceof EObject && (order = this.findElementOrder(item)) != -1) {
                this.paintElementOrder(order, event);
            }
        }
    }

    private void paintOrderArrow(Event event) {
        event.gc.setFont(this.arrowFont);
        event.gc.fillRectangle(event.x + event.width, event.y, this.currentFontSize + 2, event.height);
        event.gc.drawText("\u00f2", event.x + event.width, event.y + event.height / 10);
    }

    private int findElementOrder(TreeItem item) {
        Object grandParentData;
        TreeItem grandParentItem;
        Object parentData;
        TreeItem parentItem = item.getParentItem();
        if (parentItem != null && (parentData = parentItem.getData()) instanceof LinkItemProvider && (grandParentItem = parentItem.getParentItem()) != null && (grandParentData = grandParentItem.getData()) instanceof EObject) {
            return this.findElementOrder((EObject)item.getData(), (LinkItemProvider)((Object)parentData), (EObject)grandParentData);
        }
        return -1;
    }

    private int findElementOrder(EObject element, LinkItemProvider parentLink, EObject parentElement) {
        EReference reference = parentLink.getReference();
        if (reference.isMany() && reference.isOrdered()) {
            EList list = (EList)parentElement.eGet((EStructuralFeature)reference);
            Iterator iterator = list.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                EObject listElement = (EObject)iterator.next();
                if (listElement == element) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private String orderStringFor(int order) {
        return "[" + order + "]";
    }

    private void paintElementOrder(int order, Event event) {
        String string = this.orderStringFor(order);
        Point textExtent = event.gc.textExtent(string);
        event.gc.fillRectangle(event.x + event.width - 3, event.y, textExtent.x + 6, event.height);
        int posY = event.y + (event.height - textExtent.y) / 2;
        event.gc.drawText(string, event.x + event.width, posY);
    }

    private void setupTreeCustomPaint(Tree tree) {
        tree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                CustomTreePainter.this.handleMeasureItem(event);
            }
        });
        tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                CustomTreePainter.this.handlePaintItem(event);
            }
        });
    }

    public void dispose() {
        if (this.arrowFont != null) {
            this.arrowFont.dispose();
        }
    }
}

