/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.editors;

import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.editors.MetaclassViewer;
import org.eclipse.gmt.modisco.common.editor.util.ImageProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MetaclassViewToolBar {
    private final ToolBar toolBar;
    private MetaclassViewer metaclassViewer;
    private ToolItem btnSortByName;
    private ToolItem btnSortByCount;
    private ToolItem btnShowMetaclassesFullQualifiedName;
    private ToolItem btnShowEmptyMetaclasses;
    private ToolItem btnGroupByPackage;
    private ToolItem btnDisplayInstancesOfSubclasses;
    private ToolItem btnDerivationTree;
    private final EditorConfiguration editorConfiguration;

    public MetaclassViewToolBar(Composite parent, EditorConfiguration editorConfiguration) {
        this.editorConfiguration = editorConfiguration;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 30;
        gridLayout.marginHeight = 2;
        gridLayout.marginTop = 1;
        parent.setLayout((Layout)gridLayout);
        this.toolBar = new ToolBar(parent, 0);
        GridData toolBarGridData = new GridData();
        toolBarGridData.grabExcessHorizontalSpace = false;
        toolBarGridData.horizontalAlignment = 4;
        this.toolBar.setLayoutData((Object)toolBarGridData);
        this.createToolButtons();
        this.initialize();
    }

    public void setMetaclassViewer(MetaclassViewer metaclassViewer) {
        this.metaclassViewer = metaclassViewer;
    }

    private void createToolButtons() {
        this.btnSortByName = new ToolItem(this.toolBar, 16);
        this.btnSortByName.setToolTipText("Sort by Name");
        this.btnSortByName.setImage(ImageProvider.getInstance().getSortInstancesIcon());
        this.btnSortByName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassViewToolBar.this.metaclassViewer.setSortMode(EditorConfiguration.MetaclassesSortMode.ByName);
            }
        });
        this.btnSortByCount = new ToolItem(this.toolBar, 16);
        this.btnSortByCount.setToolTipText("Sort by Count");
        this.btnSortByCount.setImage(ImageProvider.getInstance().getSortNumericallyIcon());
        this.btnSortByCount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassViewToolBar.this.metaclassViewer.setSortMode(EditorConfiguration.MetaclassesSortMode.ByCount);
            }
        });
        this.btnShowMetaclassesFullQualifiedName = new ToolItem(this.toolBar, 32);
        this.btnShowMetaclassesFullQualifiedName.setToolTipText("Show Full Qualified Names");
        this.btnShowMetaclassesFullQualifiedName.setImage(ImageProvider.getInstance().getShowFullQualifiedNamesIcon());
        this.btnShowMetaclassesFullQualifiedName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassViewToolBar.this.metaclassViewer.setShowMetaclassesFullQualifiedNames(MetaclassViewToolBar.this.btnShowMetaclassesFullQualifiedName.getSelection());
            }
        });
        this.btnShowEmptyMetaclasses = new ToolItem(this.toolBar, 32);
        this.btnShowEmptyMetaclasses.setToolTipText("Show Empty Metaclasses");
        this.btnShowEmptyMetaclasses.setImage(ImageProvider.getInstance().getShowEmptyMetaclassesIcon());
        this.btnShowEmptyMetaclasses.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassViewToolBar.this.metaclassViewer.setShowEmptyMetaclasses(MetaclassViewToolBar.this.btnShowEmptyMetaclasses.getSelection());
            }
        });
        this.btnGroupByPackage = new ToolItem(this.toolBar, 32);
        this.btnGroupByPackage.setToolTipText("Group by Package");
        this.btnGroupByPackage.setImage(ImageProvider.getInstance().getPackageIcon());
        this.btnGroupByPackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassViewToolBar.this.metaclassViewer.setGroupByPackage(MetaclassViewToolBar.this.btnGroupByPackage.getSelection());
            }
        });
        this.btnDisplayInstancesOfSubclasses = new ToolItem(this.toolBar, 32);
        this.btnDisplayInstancesOfSubclasses.setToolTipText("Display Instances of Subclasses");
        this.btnDisplayInstancesOfSubclasses.setImage(ImageProvider.getInstance().getDerivedInstancesIcon());
        this.btnDisplayInstancesOfSubclasses.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassViewToolBar.this.metaclassViewer.setDisplayInstancesOfSubclasses(MetaclassViewToolBar.this.btnDisplayInstancesOfSubclasses.getSelection());
            }
        });
        this.btnDerivationTree = new ToolItem(this.toolBar, 32);
        this.btnDerivationTree.setToolTipText("Show Derivation Tree");
        this.btnDerivationTree.setImage(ImageProvider.getInstance().getDerivationTreeIcon());
        this.btnDerivationTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassViewToolBar.this.metaclassViewer.setShowDerivationTree(MetaclassViewToolBar.this.btnDerivationTree.getSelection());
                MetaclassViewToolBar.this.btnGroupByPackage.setEnabled(!MetaclassViewToolBar.this.btnDerivationTree.getSelection());
            }
        });
    }

    private void initialize() {
        EditorConfiguration.MetaclassesSortMode metaclassesSortMode = this.editorConfiguration.getMetaclassesSortMode();
        if (metaclassesSortMode == EditorConfiguration.MetaclassesSortMode.ByName) {
            this.btnSortByName.setSelection(true);
        } else if (metaclassesSortMode == EditorConfiguration.MetaclassesSortMode.ByCount) {
            this.btnSortByCount.setSelection(true);
        }
        this.btnShowMetaclassesFullQualifiedName.setSelection(this.editorConfiguration.isShowMetaclassesFullQualifiedNames());
        this.btnShowEmptyMetaclasses.setSelection(this.editorConfiguration.isShowEmptyMetaclasses());
        this.btnGroupByPackage.setSelection(this.editorConfiguration.isGroupByPackage());
        this.btnDisplayInstancesOfSubclasses.setSelection(this.editorConfiguration.isDisplayInstancesOfSubclasses());
        this.btnDerivationTree.setSelection(this.editorConfiguration.isShowDerivationTree());
        this.btnGroupByPackage.setEnabled(!this.editorConfiguration.isShowDerivationTree());
    }
}

