/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.extensions.icons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.extensions.AbstractRegistry;
import org.eclipse.gmt.modisco.common.editor.extensions.icons.FilteredIconProvider;
import org.eclipse.gmt.modisco.common.editor.extensions.icons.IconProvider;
import org.eclipse.gmt.modisco.common.editor.util.EMFUtil;
import org.eclipse.swt.graphics.Image;

public class IconProvidersRegistry
extends AbstractRegistry {
    private static final String METACLASS_ELEMENT = "metaclass";
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.gmt.modisco.common.editor";
    private static final String EXTENSION_POINT_NAME = "icons";
    private static final String METAMODEL_ID_ATTRIBUTE = "id";
    private static final String METAMODEL_ELEMENT = "metamodel";
    private static final String ICON_PROVIDER_ELEMENT = "iconProvider";
    private static final String ICON_PROVIDER_CLASS = "class";
    private static final String FILTER_ELEMENT = "filter";
    private static final String METACLASS_NAME_ATTRIBUTE = "name";
    private static IconProvidersRegistry instance = null;
    private Map<String, List<FilteredIconProvider>> iconProviders = new HashMap<String, List<FilteredIconProvider>>();

    public static IconProvidersRegistry getInstance() {
        if (instance == null) {
            instance = new IconProvidersRegistry();
        }
        return instance;
    }

    public Image getIcon(EObject eObject) {
        EClass eClass = eObject.eClass();
        if (eClass == null) {
            return null;
        }
        String metaclassQualifiedName = EMFUtil.getMetaclassQualifiedName(eClass);
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == null) {
            return null;
        }
        String nsURI = ePackage.getNsURI();
        List<FilteredIconProvider> filteredIconProviders = this.iconProviders.get(nsURI);
        if (filteredIconProviders == null && (filteredIconProviders = this.iconProviders.get("*")) == null) {
            return null;
        }
        for (FilteredIconProvider filteredIconProvider : filteredIconProviders) {
            Image icon;
            if (!filteredIconProvider.filter(metaclassQualifiedName) || (icon = filteredIconProvider.getIcon(eObject)) == null) continue;
            return icon;
        }
        return null;
    }

    public IconProvidersRegistry() {
        IExtension[] extensions;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurationElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
            int n3 = configurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                String name = configurationElement.getName();
                if (name.equalsIgnoreCase(METAMODEL_ELEMENT)) {
                    this.readMetamodelElement(configurationElement);
                } else {
                    IconProvidersRegistry.logUnknownElement(configurationElement);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void readMetamodelElement(IConfigurationElement configurationElement) {
        IConfigurationElement[] children;
        String metamodelId = configurationElement.getAttribute(METAMODEL_ID_ATTRIBUTE);
        if (metamodelId == null) {
            IconProvidersRegistry.logMissingAttribute(configurationElement, METAMODEL_ID_ATTRIBUTE);
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = children = configurationElement.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String name = child.getName();
            if (name.equalsIgnoreCase(ICON_PROVIDER_ELEMENT)) {
                this.readIconProviderElement(child, metamodelId);
            } else {
                IconProvidersRegistry.logUnknownElement(configurationElement);
            }
            ++n2;
        }
    }

    private void readIconProviderElement(IConfigurationElement configurationElement, String metamodelId) {
        Object iconProviderObject;
        HashSet<String> filteredMetaclasses = null;
        IConfigurationElement[] filterElements = configurationElement.getChildren(FILTER_ELEMENT);
        if (filterElements.length > 0) {
            IConfigurationElement[] metaclassElements;
            IConfigurationElement[] iConfigurationElementArray = metaclassElements = filterElements[0].getChildren(METACLASS_ELEMENT);
            int n = metaclassElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement metaclassElement = iConfigurationElementArray[n2];
                String metaclassName = metaclassElement.getAttribute(METACLASS_NAME_ATTRIBUTE);
                if (metaclassName != null) {
                    if (filteredMetaclasses == null) {
                        filteredMetaclasses = new HashSet<String>();
                    }
                    filteredMetaclasses.add(metaclassName);
                }
                ++n2;
            }
        }
        final HashSet<String> fFilteredMetaclasses = filteredMetaclasses;
        try {
            iconProviderObject = configurationElement.createExecutableExtension(ICON_PROVIDER_CLASS);
        }
        catch (CoreException e) {
            MoDiscoEditorPlugin.INSTANCE.log((Object)e);
            return;
        }
        if (iconProviderObject == null) {
            IconProvidersRegistry.logMissingAttribute(configurationElement, ICON_PROVIDER_CLASS);
            return;
        }
        List<FilteredIconProvider> filteredIconProviders = this.iconProviders.get(metamodelId);
        if (filteredIconProviders == null) {
            filteredIconProviders = new ArrayList<FilteredIconProvider>();
        }
        if (iconProviderObject instanceof FilteredIconProvider) {
            final FilteredIconProvider filteredIconProvider = (FilteredIconProvider)iconProviderObject;
            filteredIconProviders.add(new FilteredIconProvider(){

                public Image getIcon(EObject object) {
                    return filteredIconProvider.getIcon(object);
                }

                public boolean filter(String metaclass) {
                    if (fFilteredMetaclasses != null && !fFilteredMetaclasses.contains(metaclass)) {
                        return false;
                    }
                    return filteredIconProvider.filter(metaclass);
                }
            });
        } else if (iconProviderObject instanceof IconProvider) {
            final IconProvider iconProvider = (IconProvider)iconProviderObject;
            FilteredIconProvider filteredNameProvider = new FilteredIconProvider(){

                public Image getIcon(EObject object) {
                    return iconProvider.getIcon(object);
                }

                public boolean filter(String metaclass) {
                    if (fFilteredMetaclasses == null) {
                        return true;
                    }
                    return fFilteredMetaclasses.contains(metaclass);
                }
            };
            filteredIconProviders.add(filteredNameProvider);
        } else {
            IconProvidersRegistry.logError(configurationElement, "Given class is not an IconProvider");
        }
        this.iconProviders.put(metamodelId, filteredIconProviders);
    }
}

