/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFUtil {
    public static boolean isInFirstResource(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null) {
            return false;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return false;
        }
        EList resources = resourceSet.getResources();
        return resources.size() > 0 && resourceSet.getResources().get(0) == resource;
    }

    public static String getMetaclassQualifiedName(EClass eClass) {
        ArrayList<String> qualifiedNameParts = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null) {
            qualifiedNameParts.add(ePackage.getName());
            ePackage = ePackage.getESuperPackage();
        }
        int i = qualifiedNameParts.size() - 1;
        while (i >= 0) {
            builder.append(String.valueOf((String)qualifiedNameParts.get(i)) + ".");
            --i;
        }
        builder.append(eClass.getName());
        return builder.toString();
    }

    public Collection<EObject> findInstancesOf(EClass eClass, Resource resource) {
        ArrayList<EObject> instances = new ArrayList<EObject>();
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (eObject.eClass() != eClass) continue;
            instances.add(eObject);
        }
        return instances;
    }

    public static Collection<EClass> findAllClasses(ResourceSet resourceSet) {
        TreeSet<EClass> classes = new TreeSet<EClass>(new Comparator<EClass>(){

            @Override
            public int compare(EClass c1, EClass c2) {
                return EMFUtil.getMetaclassQualifiedName(c1).compareTo(EMFUtil.getMetaclassQualifiedName(c2));
            }
        });
        EList resourcesList = resourceSet.getResources();
        HashSet<Resource> resources = new HashSet<Resource>();
        ArrayList<Resource> newResources = new ArrayList<Resource>();
        resources.addAll((Collection<Resource>)resourcesList);
        for (Resource resource : resourcesList) {
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                EClass eClass;
                EObject eObject = (EObject)allContents.next();
                if (eObject instanceof EClass) {
                    eClass = (EClass)eObject;
                    classes.add(eClass);
                    continue;
                }
                eClass = eObject.eClass();
                if (eClass == null) continue;
                classes.add(eClass);
                Resource res = eClass.eResource();
                if (res == null || resources.contains(res)) continue;
                resources.add(res);
                newResources.add(res);
            }
        }
        EMFUtil.addAll(classes, newResources);
        newResources.clear();
        ArrayList<EClass> newClasses = new ArrayList<EClass>();
        for (EClass eClass : classes) {
            EList allSuperTypes = eClass.getEAllSuperTypes();
            for (EClass superclass : allSuperTypes) {
                newClasses.add(superclass);
                Resource resource = superclass.eResource();
                if (resource == null || resources.contains(resource)) continue;
                resources.add(resource);
                newResources.add(resource);
            }
        }
        for (EClass eClass : newClasses) {
            classes.add(eClass);
        }
        EMFUtil.addAll(classes, newResources);
        return classes;
    }

    private static void addAll(Set<EClass> classes, List<Resource> resources) {
        for (Resource resource : resources) {
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof EClass)) continue;
                EClass eClass = (EClass)eObject;
                classes.add(eClass);
            }
        }
    }

    public static EClass findCommonClass(List<EObject> elements) {
        EClass eClass = null;
        for (EObject element : elements) {
            EClass elementEClass = element.eClass();
            if (eClass == null) {
                eClass = elementEClass;
                continue;
            }
            if (eClass.isSuperTypeOf(elementEClass)) continue;
            if (elementEClass.isSuperTypeOf(eClass)) {
                eClass = elementEClass;
                continue;
            }
            if ((eClass = EMFUtil.findSuperType(eClass, elementEClass)) != null) continue;
            return null;
        }
        return eClass;
    }

    private static EClass findSuperType(EClass eClass, EClass element) {
        LinkedList<EClass> breadthFirstList = new LinkedList<EClass>();
        breadthFirstList.addFirst(eClass);
        while (!breadthFirstList.isEmpty()) {
            EClass candidateClass = (EClass)breadthFirstList.poll();
            if (candidateClass.isSuperTypeOf(element)) {
                return candidateClass;
            }
            for (EClass supertype : candidateClass.getESuperTypes()) {
                breadthFirstList.addLast(supertype);
            }
        }
        return null;
    }
}

