/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.gmt.modisco.workflow.ui.DriverPage;
import org.eclipse.gmt.modisco.workflow.ui.ListDriversPage;
import org.eclipse.gmt.modisco.workflow.ui.LoadLauncherPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.TableItem;

public class DriversWizard
extends Wizard {
    private DriverPage driver;
    private LoadLauncherPage loadLauncher;
    private ControllerDriverPage controllerDriverpage;
    private ControllerWorkflowTransformation controllerWorkflow;
    private Constants mode;

    public DriversWizard(ControllerWorkflowTransformation controllerWorkflow, ControllerDriverPage controllerDriverpage, Constants mode) {
        this.controllerWorkflow = controllerWorkflow;
        this.mode = mode;
        this.controllerDriverpage = controllerDriverpage;
        if (mode.equals((Object)Constants.addMode)) {
            this.setWindowTitle("Add a MoDiscoWork");
        } else if (mode.equals((Object)Constants.editMode)) {
            this.setWindowTitle("Edit a MoDiscoWork");
        } else {
            this.setWindowTitle("Load a MoDiscoWork");
        }
    }

    public final void addPages() {
        this.driver = new DriverPage("Driver selected", this.mode, this.controllerWorkflow.getGroup());
        this.driver.setController(this.controllerDriverpage);
        if (this.mode.equals((Object)Constants.addMode)) {
            this.addPage((IWizardPage)new ListDriversPage("List of drivers", this.controllerDriverpage));
        }
        if (this.mode.equals((Object)Constants.loadMode)) {
            this.loadLauncher = new LoadLauncherPage("List of Launcher", this.controllerDriverpage);
            this.addPage((IWizardPage)this.loadLauncher);
        }
        if (!this.mode.equals((Object)Constants.loadMode)) {
            this.addPage((IWizardPage)this.driver);
        }
    }

    public boolean performFinish() {
        if (this.mode.equals((Object)Constants.addMode)) {
            this.controllerDriverpage.launchPerformFinish();
            this.controllerWorkflow.addElement(this.controllerDriverpage.getCurrentDriver().getTypeLaunchConfig(), -1, this.driver.getTransformationName(), true);
        } else if (this.mode.equals((Object)Constants.editMode)) {
            this.controllerDriverpage.launchPerformFinish();
            this.controllerWorkflow.performFinishEditTransformation(this.driver.getTransformationName());
        } else if (this.mode.equals((Object)Constants.loadMode)) {
            try {
                TableItem[] tableItemArray = this.loadLauncher.getItemsSelected();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    this.controllerWorkflow.addElement(this.loadLauncher.getLaunchConfigurationMap().get(item).getType().getIdentifier(), -1, item.getText(), true);
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

