/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.ui.common.Common;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ListDriversPage
extends WizardPage {
    private Table driversTable;
    private ControllerDriverPage controller;
    private Composite container;
    private HashMap<TableItem, DriverInterface> mapItemDriver;

    protected ListDriversPage(String pageName, ControllerDriverPage controller) {
        super(pageName, pageName, null);
        this.setImageDescriptor(Activator.getImageDescriptor("icon/bigModiscoWorkflow.png"));
        this.controller = controller;
        this.setDescription("This wizard represents the list of the transformations loaded.");
        this.mapItemDriver = new HashMap();
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.driversTable = new Table(this.container, 2560);
        this.driversTable.setLayoutData((Object)gridData);
        this.driversTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListDriversPage.this.controller.refreshDriverPage(((DriverInterface)ListDriversPage.this.mapItemDriver.get(ListDriversPage.this.driversTable.getItem(ListDriversPage.this.driversTable.getSelectionIndex()))).getTypeLaunchConfig());
                ListDriversPage.this.setErrorMessage(null);
                ListDriversPage.this.setMessage("Click next to continue");
                ListDriversPage.this.setPageComplete(true);
            }
        });
        this.loadDriver();
        this.setControl((Control)this.container);
        this.container.layout();
    }

    private void loadDriver() {
        boolean oneDriver = false;
        for (Map.Entry<String, DriverInterface> entry : this.controller.getMapNameDriver().entrySet()) {
            TableItem item = new TableItem(this.driversTable, 0);
            item.setText(entry.getKey());
            item.setImage(Common.getInstance().retrieveImageDriver(entry.getValue().getTypeLaunchConfig()));
            oneDriver = true;
            this.mapItemDriver.put(item, entry.getValue());
        }
        if (oneDriver) {
            this.setErrorMessage("Choose your MoDiscoWork type");
        } else {
            this.setErrorMessage("Any find drivers");
        }
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getShell().setSize(400, 400);
            this.getShell().setLocation(Common.getInstance().centerShell(Display.getDefault(), this.getShell()));
        }
        super.setVisible(visible);
    }
}

