/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.j2se5;

import java.io.IOException;
import java.net.URL;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.m2m.atl.core.ATLCoreException;

/**
 * @author Gabriel Barbier
 *
 */
public interface J2se5DiscovererInterface {

	/**
	 * @param javaProject
	 * @return a resource containing the j2se5 model of the Java project
	 */
	public Resource getJ2SE5ModelFromJavaSource(IJavaProject javaProject);

	/**
	 * @param javaProject
	 * @return a resource containing the Kdm model of the Java project
	 * @throws ATLCoreException 
	 */
	public Resource getKDMModelFromJavaSource(IJavaProject javaProject) throws ATLCoreException;

	/**
	 * @param javaProject
	 * @return a resource containing the Kdm model of the Java project
	 * @throws ATLCoreException 
	 */
	public Resource getKDMModelFromJavaSource(IJavaProject javaProject,
			URI kdmModelUri) throws ATLCoreException;

	/**
	 * @param J2SE5Model
	 * @return a resource containing the Kdm model obtained by the transformation of the source j2se5 model
	 * @throws IOException 
	 * @throws ATLCoreException 
	 */
	public Resource getKDMModelFromJ2SE5Model(Resource J2SE5Model)
			throws IOException, ATLCoreException;

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5DiscovererInterface#getKDMModelFromJ2SE5Model(org.eclipse.emf.ecore.resource.Resource, org.eclipse.emf.common.util.URI)
	 */
	public Resource getKDMModelFromJ2SE5Model(URI j2se5SourceModelUri,
			URI kdmModelUri) throws IOException, ATLCoreException;

	public void exportJ2se5ToKdmTransformation(final IPath pathParameter);

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5DiscovererInterface#getKDMModelFromJ2SE5ModelWithCustomTransformation(org.eclipse.emf.common.util.URI, java.net.URL, org.eclipse.emf.common.util.URI)
	 */
	public Resource getKDMModelFromJ2SE5ModelWithCustomTransformation(
			URI j2se5SourceModelUri, final URL transformation,
			URI kdmTargetModelUri) throws IOException, ATLCoreException;

}