/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hugues Dubourg (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.j2se5.popup.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmt.modisco.j2se5.J2SE5Discoverer;
import org.eclipse.gmt.modisco.j2se5.J2se5DiscovererInterface;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class ExportTransformation implements IObjectActionDelegate {

	protected IProject containingProject;
	private Shell shell;
	
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.shell = targetPart.getSite().getShell();
	}

	public void run(IAction action) {
		
		SaveAsDialog dialog = new SaveAsDialog(this.shell);
		dialog.open();

		IPath path = dialog.getResult();
		
		J2se5DiscovererInterface converter = new J2SE5Discoverer();
		converter.exportJ2se5ToKdmTransformation(path);
	}

	public void selectionChanged(IAction action, ISelection selection) {
		Object source = ((IStructuredSelection) selection).getFirstElement();
		if (source instanceof IFile) {
			this.containingProject = ((IFile) source).getProject();
		}
		if (source instanceof IFolder) {
			this.containingProject = ((IFolder) source).getProject();
		}

	}

}
