/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Work;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterBooleanValue;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterIntegerValue;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterMapValue;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterStringListValue;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterStringValue;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterValue;

/**
 * 
 * @author Nicolas Payneau
 */
public abstract class AbstractDriverExecution implements
		DriverExecutionInterface {

	public abstract void launch(ILaunchConfigurationWorkingCopy configuration,
			ILaunch launch);

	public abstract void launch(Work modiscoWork);

	/**
	 * Allows to update the LaunchConfiguration copy
	 * @param Work Work source
	 * @param copy The launchConfiguration which will updated
	 */
	public void WorkToLaunchWorkingCopy(Work Work,
			ILaunchConfigurationWorkingCopy copy) {
		for(WorkParameter parameter : Work.getParameters()){
			if(parameter.getValue() instanceof WorkParameterStringValue){
				copy.setAttribute(parameter.getName(),((WorkParameterStringValue)parameter.getValue()).getValue());
			}else if(parameter.getValue() instanceof WorkParameterStringListValue){
				copy.setAttribute(parameter.getName(),((WorkParameterStringListValue)parameter.getValue()).getValue());
			}else if(parameter.getValue() instanceof WorkParameterIntegerValue){
				copy.setAttribute(parameter.getName(),((WorkParameterIntegerValue)parameter.getValue()).getValue());
			}else if(parameter.getValue() instanceof WorkParameterBooleanValue){
				copy.setAttribute(parameter.getName(),((WorkParameterBooleanValue)parameter.getValue()).isValue());
			}else if(parameter.getValue() instanceof WorkParameterMapValue){
				copy.setAttribute(parameter.getName(),createMap((((WorkParameterMapValue)parameter.getValue()).getEntryList())));
			}			
		}
	}

	/**
	 * Allows to transform a WorkParameterMapValue to StringMap
	 * @param eMap Source map
	 * @return A string map corresponding to WorkParameterMapValue
	 */
	private Map<String, String> createMap(EMap<String, WorkParameterValue> eMap) {
		Map<String, String> stringMap = new HashMap<String, String>();
		for(Entry<String,WorkParameterValue> entry : eMap){
			if(entry.getValue() instanceof WorkParameterStringValue){
				stringMap.put(entry.getKey(),((WorkParameterStringValue)entry.getValue()).getValue());
			}else if(entry.getValue() instanceof WorkParameterStringListValue){
				stringMap.put(entry.getKey(),((WorkParameterStringListValue)entry.getValue()).toString());
			}else if(entry.getValue() instanceof WorkParameterIntegerValue){
				stringMap.put(entry.getKey(),((WorkParameterIntegerValue)entry.getValue()).toString());
			}else if(entry.getValue() instanceof WorkParameterBooleanValue){
				stringMap.put(entry.getKey(),((WorkParameterBooleanValue)entry.getValue()).toString());
			}else if(entry.getValue() instanceof WorkParameterMapValue){
				//No implementation
			}
			
		}
		return stringMap;
	}
}
