/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui;

import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.gmt.modisco.workflow.ui.common.AdditionalButtonsComposite;
import org.eclipse.gmt.modisco.workflow.ui.common.MoDiscoWorkflowPopPup;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/**
 * This class defines the main tab show in RunConfiguration
 * This tab shows user interface to create, edit, remove, load a MoDiscoWork
 * @author Nicolas Payneau
 */
@SuppressWarnings("restriction")
public class WorkflowTransformationTab extends AbstractLaunchConfigurationTab{

	private Composite rootContainer;
	private Table transformationsTable;
	private TableViewer paramTable;
	private Composite compositeParameter;
	private AdditionalButtonsComposite gpButtonTransformation;
	private MoDiscoWorkflowPopPup popUp;
	private ControllerWorkflowTransformation controller;
	private boolean isValid;
	private String resourcePath;
	private ExpandItem itemParam;
	private ExpandBar bar;
	private Label labNoParam;
	private enum state{expand,collapse,block};
	private state barState;
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		this.rootContainer = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		this.rootContainer.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;
		
		Label labelWFTransfo = new Label(this.rootContainer, SWT.NULL);
		labelWFTransfo.setText("Build your MoDiscoWorkflow");
		GridData gdLabel = new GridData();
		gdLabel.horizontalSpan = 3;
		labelWFTransfo.setLayoutData(gdLabel);
		GridData gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		this.transformationsTable = new Table(this.rootContainer, SWT.BORDER | SWT.V_SCROLL);
		this.transformationsTable.setLayoutData(gridData);
		this.transformationsTable.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				widgetSelected(e);
			}
			
			public void widgetSelected(SelectionEvent e) {
				dialogChangedContainer();
				loadParameter();
				WorkflowTransformationTab.this.itemParam.setHeight(WorkflowTransformationTab.this.compositeParameter.getBounds().height);
				//WorkflowTransformationTab.this.bar.pack();
				//WorkflowTransformationTab.this.rootContainer.pack();
			}		
		});
		this.transformationsTable.addMouseListener(new MouseAdapter() {
            @Override
			public void mouseDown(MouseEvent evt) {
            	Point p = new Point(evt.x,evt.y);
				TableItem item = WorkflowTransformationTab.this.transformationsTable.getItem(p);
				if(evt.button==3){
					if(item==null){
						WorkflowTransformationTab.this.popUp.createPopupMenuNoSelectionItem(getShell());
						WorkflowTransformationTab.this.transformationsTable.setMenu (WorkflowTransformationTab.this.popUp.getMenuNoSelection());
					}else{
						WorkflowTransformationTab.this.popUp.createPopupMenuSelectionItem(getShell());
						WorkflowTransformationTab.this.transformationsTable.setMenu (WorkflowTransformationTab.this.popUp.getMenuSelection());
					}
				}
            }
		});
		
		this.gpButtonTransformation = new AdditionalButtonsComposite(this.rootContainer, SWT.NONE,this.transformationsTable,this.controller);
		this.popUp = new MoDiscoWorkflowPopPup(this.gpButtonTransformation);
		createParameterBar();	
		setControl(this.rootContainer);
	}
	
	/**
	 * Allows to create parameter bar
	 */
	private void createParameterBar() {
		this.bar = new ExpandBar (this.rootContainer, SWT.V_SCROLL| SWT.H_SCROLL);
		GridData gridDataBar = new GridData();
		gridDataBar.horizontalSpan = 2;
		gridDataBar.grabExcessHorizontalSpace = true;
		gridDataBar.horizontalAlignment = GridData.FILL;
		gridDataBar.verticalAlignment = GridData.END;
		this.bar.setLayoutData(gridDataBar);
		this.bar.addExpandListener(new ExpandListener(){
			public void itemCollapsed(ExpandEvent e) {
				WorkflowTransformationTab.this.barState = state.collapse;
			}
			public void itemExpanded(ExpandEvent e) {				
				WorkflowTransformationTab.this.barState = state.expand;
			}
		});
		//To repaint the bar with good size
		this.bar.addPaintListener(new PaintListener(){
			public void paintControl(PaintEvent e) {
				if(!WorkflowTransformationTab.this.itemParam.getExpanded()){
					if(WorkflowTransformationTab.this.barState== state.collapse){
						WorkflowTransformationTab.this.barState = state.block;
						WorkflowTransformationTab.this.transformationsTable.notifyListeners(SWT.Selection, null);
					}
				}else{
					if(WorkflowTransformationTab.this.barState==state.expand){
						WorkflowTransformationTab.this.barState = state.block;
						WorkflowTransformationTab.this.transformationsTable.notifyListeners(SWT.Selection, null);
					}
				}
			}
		});
		this.compositeParameter = new Composite (this.bar,  SWT.NULL);
		GridLayout layoutParameter = new GridLayout();
		layoutParameter.marginTop =layoutParameter.marginBottom = 10;
		layoutParameter.verticalSpacing = 10;
		GridData gdParam = new GridData();
		gdParam.grabExcessHorizontalSpace = true;
		gdParam.grabExcessVerticalSpace = true;
		this.compositeParameter.setLayoutData(gdParam);
		this.compositeParameter.setLayout(layoutParameter);
		createParameterTable(false);
		this.itemParam = new ExpandItem (this.bar, SWT.NONE, 0);
		this.itemParam.setText("Parameters description");
		this.itemParam.setControl(this.compositeParameter);
		this.itemParam.setHeight(this.compositeParameter.computeSize(SWT.DEFAULT, SWT.DEFAULT).y);
	}

	/**
	 * Allows to create parameter table
	 * @param parameter True if the MoDiscoWork selected has parameters otherwise false
	 */
	private void createParameterTable(boolean parameter){
		for(Control c : this.compositeParameter.getChildren()){
			c.dispose();
		}
		if(!parameter){
			this.labNoParam = new Label(this.compositeParameter,SWT.NONE);
			this.labNoParam.setText("No parameter description");
		}else{
			this.paramTable = new TableViewer(this.compositeParameter, SWT.V_SCROLL | SWT.BORDER | SWT.FULL_SELECTION);
			GridData gridData1 = new GridData();
			gridData1.grabExcessHorizontalSpace = true;
			gridData1.horizontalAlignment = GridData.FILL;
			gridData1.verticalAlignment = GridData.FILL;
			gridData1.grabExcessVerticalSpace = true;
			this.paramTable.getTable().setLayoutData(gridData1);
			this.paramTable.getTable().setHeaderVisible(true);
			this.paramTable.getTable().setLinesVisible(true);

			TableColumnLayout ad = new TableColumnLayout();
			this.compositeParameter.setLayout(ad);

			TableViewerColumn columnDirection = new TableViewerColumn(this.paramTable, SWT.NONE);
			columnDirection.getColumn().setText("Direction");
			columnDirection.getColumn().setMoveable(true);
			ad.setColumnData(columnDirection.getColumn(), new ColumnWeightData(26, 60));
			
			TableViewerColumn columnName = new TableViewerColumn(this.paramTable, SWT.NONE);
			columnName.getColumn().setText("Name");
			columnName.getColumn().setMoveable(true);
			ad.setColumnData(columnName.getColumn(), new ColumnWeightData(26, 100));

			TableViewerColumn columnType = new TableViewerColumn(this.paramTable, SWT.NONE);
			columnType.getColumn().setText("Type");
			columnType.getColumn().setMoveable(true);
			ad.setColumnData(columnType.getColumn(), new ColumnWeightData(26, 100));
			
			TableViewerColumn columnRequired = new TableViewerColumn(this.paramTable, SWT.NONE);
			columnRequired.getColumn().setText("Required");
			columnRequired.getColumn().setMoveable(true);
			ad.setColumnData(columnRequired.getColumn(), new ColumnWeightData(26, 60));

					
			TableViewerColumn columnDescription = new TableViewerColumn(this.paramTable, SWT.NONE);
			columnDescription.getColumn().setText("Description");
			columnDescription.getColumn().setMoveable(true);
			ad.setColumnData(columnDescription.getColumn(), new ColumnWeightData(26, 200));

			GridData gridData = new GridData();
			gridData.grabExcessHorizontalSpace = true;
			gridData.horizontalAlignment = GridData.FILL;
			gridData.verticalAlignment = GridData.FILL;
			gridData.grabExcessVerticalSpace = true;
			this.compositeParameter.setLayoutData(gridData);
		}
	}
	
	/**
	 * Allows to load parameter of MoDiscoWork selected
	 */
	private void loadParameter() {
		List<WorkParameter> paramList = null;
		if(this.transformationsTable.getSelectionIndex()!=-1){
			paramList = this.controller.getAllParameterOfDriver(this.transformationsTable.getSelectionIndex());		
		}
		if(paramList!=null){
			createParameterTable(true);
			this.paramTable.getTable().removeAll();
			for(WorkParameter param : paramList){
				TableItem item = new TableItem(this.paramTable.getTable(),SWT.NONE);
				item.setText(new String[]{param.getDirection().toString(),param.getName(),param.getType(),Boolean.toString(param.isRequired()),param.getDescription()});
			}
			this.paramTable.getTable().pack();
		}else{
			createParameterTable(false);
			this.labNoParam.pack();
		}
		this.compositeParameter.pack();
	}
	
	private void updateStatus(String message) {
		setMessage("Build your MoDiscoWorkflow");
		setErrorMessage(message);
		if(message == null){
			this.isValid = true;
		}else{
			this.isValid = false;
		}
		this.rootContainer.setSize(this.rootContainer.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		this.rootContainer.layout();
		this.compositeParameter.layout();
		updateLaunchConfigurationDialog();
	}

	/**
	 * Update the status when the dialog changed container
	 */
	private void dialogChangedContainer() {
		String transformationName = this.controller.allComponentsHaveConfiguration();
		if(transformationName!=null){
			updateStatus("The transformation "+transformationName+" does not have configuration anymore. You have to delete it to execute the workflow");
			gpButtonTransformation.enabledButtonToManageMoDiscoWorkflow(false);
			popUp.enabledButtonToManageMoDiscoWorkflow(false);
			return;
		}else{
			gpButtonTransformation.enabledButtonToManageMoDiscoWorkflow(true);
			popUp.enabledButtonToManageMoDiscoWorkflow(true);
		}
		updateStatus(null);	
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#getName()
	 */
	public String getName() {
		return "MoDiscoWorkflow";
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.AbstractLaunchConfigurationTab#getImage()
	 */
	@Override
	public Image getImage() {
		return Activator.getImageDescriptor(Constants.pathLittleImage).createImage();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.AbstractLaunchConfigurationTab#isValid(org.eclipse.debug.core.ILaunchConfiguration)
	 */
	@Override
	public boolean isValid(ILaunchConfiguration launchConfig) {
		return this.isValid;
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#initializeFrom(org.eclipse.debug.core.ILaunchConfiguration)
	 */
	public void initializeFrom(ILaunchConfiguration configuration) {
		try {
			String id = configuration.getAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow,MoDiscoWorkflowLaunchConstants.idMinimaliste);
			this.controller = new ControllerWorkflowTransformation(id, configuration.getName());
			this.controller.setGroup(((LaunchConfigurationsDialog)getLaunchConfigurationDialog()).getLaunchGroup());
			this.gpButtonTransformation.setController(this.controller);
			this.controller.initializationWorkflowResource(configuration,this.resourcePath);
		} catch (CoreException e) {
			e.printStackTrace();
		}
		this.controller.refresh(-1);
		dialogChangedContainer();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#performApply(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
	 */
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		this.controller.saveWorkflowResource(configuration,true);
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#setDefaults(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
	 */
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {	
	}
	
	public ControllerWorkflowTransformation getController() {
		return this.controller;
	}
	
	public void setResourcePath(String resourcePath) {
		this.resourcePath = resourcePath;
	}
	
	
}
