/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.discoverersmanager;

public class DiscoveryParameterImpl implements DiscoveryParameter {

	private String description;
	private String name;
	private DiscoveryParameterDirectionKind parameterDirectionKind;
	private Class<?> type;
	private boolean required;
	
	public DiscoveryParameterImpl() {
		this("mock parameter");
	}
	
	public DiscoveryParameterImpl(String name) {
		this(name, DiscoveryParameterDirectionKind.inout, null, true);
	}

	public DiscoveryParameterImpl(String name, DiscoveryParameterDirectionKind parameterDirectionKind,
			Class<?> type, boolean required) {
		this.name = name;
		this.description = this.getName();
		this.parameterDirectionKind = parameterDirectionKind;
		if (type != null) {
			this.type = type;
		} else {
			this.type = String.class;
		}
		this.required = required;
	}
	
	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public DiscoveryParameterDirectionKind getParameterDirectionKind() {
		return this.parameterDirectionKind;
	}

	public void setParameterDirectionKind(
			DiscoveryParameterDirectionKind parameterDirectionKind) {
		this.parameterDirectionKind = parameterDirectionKind;
	}

	public Class<?> getType() {
		return this.type;
	}

	public void setType(Class<?> type) {
		this.type = type;
	}

	public boolean isRequired() {
		return this.required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}
	
	

}
