/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.discoverersmanager.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.discoverersmanager.Discoverer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

/**
 * @author Gabriel Barbier
 * 
 */
public class MenuListenerHandler implements SelectionListener {

	private final Discoverer discoverer;
	private final Object[] sources;
	private final URI targetUri;

	// private final Shell shell;

	public MenuListenerHandler(Discoverer discovererParameter,
			Object[] sourceParameter, URI targetUriParameter) {
		this.discoverer = discovererParameter;
		this.sources = sourceParameter;
		this.targetUri = targetUriParameter;

		// this.shell = null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse
	 * .swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
		// we will not use this method
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt
	 * .events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent event) {
		// if (this.discoverer instanceof ExtendedInterface) {
		//			
		// ((ExtendedInterface) this.discoverer).setShell(this.shell);
		// }
		//		
		for (final Object source : this.sources) {
			Job job = new Job("Discover resources ...") {

				@Override
				protected IStatus run(IProgressMonitor monitor) {
					MenuListenerHandler.this.discoverer.discoverElement(source,
							MenuListenerHandler.this.targetUri);
					return Status.OK_STATUS;
				}

			};
			job.schedule();
		}
	}

}
