/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.discoverersmanager.ui.launch.parametersdisplay;

import java.util.List;

import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.data.DiscoveryParameterDisplay;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/**
 * @author GBarbier
 *
 */
public class ParametersTableComposite extends Composite {

	private TableViewer tableViewer = null;

//	private ParametersTableLabelProvider labelProvider = null;
	private ParametersTableContentProvider contentProvider = null;
	private ParametersTableEditingSupport editingSupport = null;
	@SuppressWarnings("unused")
	private ColumnViewerSorter sorter = null;
	
	public ParametersTableComposite(Composite parent, int style, List<DiscoveryParameterDisplay> discoveryParameters) {
		super(parent, style);
		initialize();
		this.initializeTableProviders();
		this.initializeTableContents(discoveryParameters);
	}

	/**
	 * @param discoveryParameters
	 */
	private final void initializeTableContents(
			List<DiscoveryParameterDisplay> discoveryParameters) {
		
		DiscoveryParameterDisplay[] parameters = new DiscoveryParameterDisplay[discoveryParameters.size()];
		discoveryParameters.toArray(parameters);
		this.tableViewer.setInput(parameters);
	}

	private final void initialize() {
		this.tableViewer = new TableViewer(this, SWT.V_SCROLL | SWT.BORDER | SWT.FULL_SELECTION);
		GridData gridData1 = new GridData();
		gridData1.grabExcessHorizontalSpace = true;
		gridData1.horizontalAlignment = GridData.FILL;
		gridData1.verticalAlignment = GridData.FILL;
		gridData1.grabExcessVerticalSpace = true;
		this.tableViewer.getTable().setLayoutData(gridData1);
		this.tableViewer.getTable().setHeaderVisible(true);
		this.tableViewer.getTable().setLinesVisible(true);
		
		
		TableColumnLayout ad = new TableColumnLayout();
		this.setLayout(ad);

		TableViewerColumn columnName = new TableViewerColumn(this.tableViewer, SWT.NONE);
//		columnName.getColumn().setWidth(200);
		columnName.getColumn().setText("Name");
		columnName.getColumn().setMoveable(true);
		columnName.setLabelProvider(new ColumnLabelProvider() {
			public String getText(Object element) {
				return ((DiscoveryParameterDisplay) element).getName();
			}
		});
		this.sorter = new ColumnViewerSorter(this.tableViewer, columnName);
		
		ad.setColumnData(columnName.getColumn(), new ColumnWeightData(26, 200));
		
		TableViewerColumn columnRequired = new TableViewerColumn(this.tableViewer, SWT.NONE);
//		columnRequired.getColumn().setWidth(60);
		columnRequired.getColumn().setText("Usage");
		columnRequired.getColumn().setMoveable(true);
		columnRequired.setLabelProvider(new ColumnLabelProvider() {
			public String getText(Object element) {
				String result = null;
				if (((DiscoveryParameterDisplay) element).isRequired()) {
					result = "required";
				} else {
					result = "optional";
				}
				return result;
			}
		});
		ad.setColumnData(columnRequired.getColumn(), new ColumnWeightData(8, 60));

		TableViewerColumn columnValue = new TableViewerColumn(this.tableViewer, SWT.NONE);
//		columnValue.getColumn().setWidth(500);
		columnValue.getColumn().setText("Value");
		columnValue.getColumn().setMoveable(true);
		columnValue.setLabelProvider(new ColumnLabelProvider() {
			public String getText(Object element) {
				String result = null;
				if (((DiscoveryParameterDisplay) element).getValue() != null) {
					result = ((DiscoveryParameterDisplay) element).getValue().toString();
				}
				return result;
			}
		});
		this.editingSupport = new ParametersTableEditingSupport(this.tableViewer);
		columnValue.setEditingSupport(this.editingSupport);
		ad.setColumnData(columnValue.getColumn(), new ColumnWeightData(66, 500));

//		setLayout(new GridLayout());
		GridData gridData = new GridData();
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		this.setLayoutData(gridData);
		
	}

	private final void initializeTableProviders() {
//		this.labelProvider = new ParametersTableLabelProvider();
//		this.tableViewer.setLabelProvider(this.labelProvider);
		
		this.contentProvider = new ParametersTableContentProvider();
		this.tableViewer.setContentProvider(this.contentProvider);
	}

	/**
	 * @param discoveryParameters
	 */
	public void updateDisplayParameters(
			List<DiscoveryParameterDisplay> discoveryParameters) {
		this.initializeTableContents(discoveryParameters);
		this.tableViewer.refresh();
		this.setSize(this.tableViewer.getTable().getSize());
		this.pack();
	}
	
	private static class ColumnViewerSorter extends ViewerComparator {
		public static final int ASC = 1;
		
		public static final int NONE = 0;
		
		public static final int DESC = -1;
		
		private int direction = ColumnViewerSorter.NONE;
		
		private TableViewerColumn column;
		
		private ColumnViewer viewer;
		
		public ColumnViewerSorter(ColumnViewer viewer, TableViewerColumn column) {
			this.column = column;
			this.viewer = viewer;
			this.column.getColumn().addSelectionListener(new SelectionAdapter() {

				public void widgetSelected(SelectionEvent e) {
					if( ColumnViewerSorter.this.viewer.getComparator() != null ) {
						if( ColumnViewerSorter.this.viewer.getComparator() == ColumnViewerSorter.this ) {
							int tdirection = ColumnViewerSorter.this.direction;
							
							if( tdirection == ASC ) {
								setSorter(ColumnViewerSorter.this, DESC);
							} else if( tdirection == DESC ) {
								setSorter(ColumnViewerSorter.this, NONE);
							}
						} else {
							setSorter(ColumnViewerSorter.this, ASC);
						}
					} else {
						setSorter(ColumnViewerSorter.this, ASC);
					}
				}
			});
		}
		
		public void setSorter(ColumnViewerSorter sorter, int direction) {
			if( direction == NONE ) {
				this.column.getColumn().getParent().setSortColumn(null);
				this.column.getColumn().getParent().setSortDirection(SWT.NONE);
				this.viewer.setComparator(null);
			} else {
				this.column.getColumn().getParent().setSortColumn(this.column.getColumn());
				sorter.direction = direction;
				
				if( direction == ASC ) {
					this.column.getColumn().getParent().setSortDirection(SWT.DOWN);
				} else {
					this.column.getColumn().getParent().setSortDirection(SWT.UP);
				}
				
				if( this.viewer.getComparator() == sorter ) {
					this.viewer.refresh();
				} else {
					this.viewer.setComparator(sorter);
				}
				
			}
		}

		public int compare(Viewer viewer, Object e1, Object e2) {
			int result = 0;
			DiscoveryParameterDisplay display1 = (DiscoveryParameterDisplay) e1;
			DiscoveryParameterDisplay display2 = (DiscoveryParameterDisplay) e2;
			result = display1.getName().compareToIgnoreCase(display2.getName());
			return this.direction * result;
		}
		
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
