/**
 * *******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sbastien Minguet (Mia-Software) - initial API and implementation
 *     Frdric Madiot (Mia-Software) - initial API and implementation
 *     Fabien Giquel (Mia-Software) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - initial API and implementation
 *     Erwan Breton (Sodifrance) - initial API and implementation
 * *******************************************************************************
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.j2se5.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.gmt.modisco.j2se5.Comment;
import org.eclipse.gmt.modisco.j2se5.J2se5Package;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Comment</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.CommentImpl#getContent <em>Content</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.CommentImpl#isIsEnclosedByParent <em>Is Enclosed By Parent</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.CommentImpl#isIsPrefixOfParent <em>Is Prefix Of Parent</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class CommentImpl extends ASTNodeImpl implements Comment {
	/**
	 * The default value of the '{@link #getContent() <em>Content</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContent()
	 * @generated
	 * @ordered
	 */
	protected static final String CONTENT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getContent() <em>Content</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContent()
	 * @generated
	 * @ordered
	 */
	protected String content = CONTENT_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsEnclosedByParent() <em>Is Enclosed By Parent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsEnclosedByParent()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_ENCLOSED_BY_PARENT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsEnclosedByParent() <em>Is Enclosed By Parent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsEnclosedByParent()
	 * @generated
	 * @ordered
	 */
	protected boolean isEnclosedByParent = IS_ENCLOSED_BY_PARENT_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsPrefixOfParent() <em>Is Prefix Of Parent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsPrefixOfParent()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_PREFIX_OF_PARENT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsPrefixOfParent() <em>Is Prefix Of Parent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsPrefixOfParent()
	 * @generated
	 * @ordered
	 */
	protected boolean isPrefixOfParent = IS_PREFIX_OF_PARENT_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return J2se5Package.Literals.COMMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getContent() {
		return content;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContent(String newContent) {
		String oldContent = content;
		content = newContent;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.COMMENT__CONTENT, oldContent, content));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsEnclosedByParent() {
		return isEnclosedByParent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsEnclosedByParent(boolean newIsEnclosedByParent) {
		boolean oldIsEnclosedByParent = isEnclosedByParent;
		isEnclosedByParent = newIsEnclosedByParent;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.COMMENT__IS_ENCLOSED_BY_PARENT, oldIsEnclosedByParent, isEnclosedByParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsPrefixOfParent() {
		return isPrefixOfParent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsPrefixOfParent(boolean newIsPrefixOfParent) {
		boolean oldIsPrefixOfParent = isPrefixOfParent;
		isPrefixOfParent = newIsPrefixOfParent;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.COMMENT__IS_PREFIX_OF_PARENT, oldIsPrefixOfParent, isPrefixOfParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case J2se5Package.COMMENT__CONTENT:
				return getContent();
			case J2se5Package.COMMENT__IS_ENCLOSED_BY_PARENT:
				return isIsEnclosedByParent() ? Boolean.TRUE : Boolean.FALSE;
			case J2se5Package.COMMENT__IS_PREFIX_OF_PARENT:
				return isIsPrefixOfParent() ? Boolean.TRUE : Boolean.FALSE;
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case J2se5Package.COMMENT__CONTENT:
				setContent((String)newValue);
				return;
			case J2se5Package.COMMENT__IS_ENCLOSED_BY_PARENT:
				setIsEnclosedByParent(((Boolean)newValue).booleanValue());
				return;
			case J2se5Package.COMMENT__IS_PREFIX_OF_PARENT:
				setIsPrefixOfParent(((Boolean)newValue).booleanValue());
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case J2se5Package.COMMENT__CONTENT:
				setContent(CONTENT_EDEFAULT);
				return;
			case J2se5Package.COMMENT__IS_ENCLOSED_BY_PARENT:
				setIsEnclosedByParent(IS_ENCLOSED_BY_PARENT_EDEFAULT);
				return;
			case J2se5Package.COMMENT__IS_PREFIX_OF_PARENT:
				setIsPrefixOfParent(IS_PREFIX_OF_PARENT_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case J2se5Package.COMMENT__CONTENT:
				return CONTENT_EDEFAULT == null ? content != null : !CONTENT_EDEFAULT.equals(content);
			case J2se5Package.COMMENT__IS_ENCLOSED_BY_PARENT:
				return isEnclosedByParent != IS_ENCLOSED_BY_PARENT_EDEFAULT;
			case J2se5Package.COMMENT__IS_PREFIX_OF_PARENT:
				return isPrefixOfParent != IS_PREFIX_OF_PARENT_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (content: ");
		result.append(content);
		result.append(", isEnclosedByParent: ");
		result.append(isEnclosedByParent);
		result.append(", isPrefixOfParent: ");
		result.append(isPrefixOfParent);
		result.append(')');
		return result.toString();
	}

} //CommentImpl
