/**
 * *******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sbastien Minguet (Mia-Software) - initial API and implementation
 *     Frdric Madiot (Mia-Software) - initial API and implementation
 *     Fabien Giquel (Mia-Software) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - initial API and implementation
 *     Erwan Breton (Sodifrance) - initial API and implementation
 * *******************************************************************************
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.j2se5.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.gmt.modisco.j2se5.AbstractTypeDeclaration;
import org.eclipse.gmt.modisco.j2se5.J2se5Package;
import org.eclipse.gmt.modisco.j2se5.Model;
import org.eclipse.gmt.modisco.j2se5.PackageDeclaration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Package Declaration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.PackageDeclarationImpl#getQualifiedName <em>Qualified Name</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.PackageDeclarationImpl#getOwnedElements <em>Owned Elements</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.PackageDeclarationImpl#getModel <em>Model</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.PackageDeclarationImpl#getOwnedPackages <em>Owned Packages</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.impl.PackageDeclarationImpl#getPackageDeclaration <em>Package Declaration</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PackageDeclarationImpl extends NamedElementImpl implements PackageDeclaration {
	/**
	 * The default value of the '{@link #getQualifiedName() <em>Qualified Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQualifiedName()
	 * @generated
	 * @ordered
	 */
	protected static final String QUALIFIED_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getQualifiedName() <em>Qualified Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQualifiedName()
	 * @generated
	 * @ordered
	 */
	protected String qualifiedName = QUALIFIED_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOwnedElements() <em>Owned Elements</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnedElements()
	 * @generated
	 * @ordered
	 */
	protected EList<AbstractTypeDeclaration> ownedElements;

	/**
	 * The cached value of the '{@link #getOwnedPackages() <em>Owned Packages</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnedPackages()
	 * @generated
	 * @ordered
	 */
	protected EList<PackageDeclaration> ownedPackages;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackageDeclarationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return J2se5Package.Literals.PACKAGE_DECLARATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getQualifiedName() {
		return qualifiedName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setQualifiedName(String newQualifiedName) {
		String oldQualifiedName = qualifiedName;
		qualifiedName = newQualifiedName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.PACKAGE_DECLARATION__QUALIFIED_NAME, oldQualifiedName, qualifiedName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AbstractTypeDeclaration> getOwnedElements() {
		if (ownedElements == null) {
			ownedElements = new EObjectContainmentWithInverseEList<AbstractTypeDeclaration>(AbstractTypeDeclaration.class, this, J2se5Package.PACKAGE_DECLARATION__OWNED_ELEMENTS, J2se5Package.ABSTRACT_TYPE_DECLARATION__PACKAGE);
		}
		return ownedElements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Model getModel() {
		if (eContainerFeatureID != J2se5Package.PACKAGE_DECLARATION__MODEL) return null;
		return (Model)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetModel(Model newModel, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newModel, J2se5Package.PACKAGE_DECLARATION__MODEL, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setModel(Model newModel) {
		if (newModel != eInternalContainer() || (eContainerFeatureID != J2se5Package.PACKAGE_DECLARATION__MODEL && newModel != null)) {
			if (EcoreUtil.isAncestor(this, newModel))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newModel != null)
				msgs = ((InternalEObject)newModel).eInverseAdd(this, J2se5Package.MODEL__OWNED_ELEMENTS, Model.class, msgs);
			msgs = basicSetModel(newModel, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.PACKAGE_DECLARATION__MODEL, newModel, newModel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<PackageDeclaration> getOwnedPackages() {
		if (ownedPackages == null) {
			ownedPackages = new EObjectContainmentWithInverseEList<PackageDeclaration>(PackageDeclaration.class, this, J2se5Package.PACKAGE_DECLARATION__OWNED_PACKAGES, J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION);
		}
		return ownedPackages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PackageDeclaration getPackageDeclaration() {
		if (eContainerFeatureID != J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION) return null;
		return (PackageDeclaration)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPackageDeclaration(PackageDeclaration newPackageDeclaration, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newPackageDeclaration, J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPackageDeclaration(PackageDeclaration newPackageDeclaration) {
		if (newPackageDeclaration != eInternalContainer() || (eContainerFeatureID != J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION && newPackageDeclaration != null)) {
			if (EcoreUtil.isAncestor(this, newPackageDeclaration))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newPackageDeclaration != null)
				msgs = ((InternalEObject)newPackageDeclaration).eInverseAdd(this, J2se5Package.PACKAGE_DECLARATION__OWNED_PACKAGES, PackageDeclaration.class, msgs);
			msgs = basicSetPackageDeclaration(newPackageDeclaration, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION, newPackageDeclaration, newPackageDeclaration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case J2se5Package.PACKAGE_DECLARATION__OWNED_ELEMENTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getOwnedElements()).basicAdd(otherEnd, msgs);
			case J2se5Package.PACKAGE_DECLARATION__MODEL:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetModel((Model)otherEnd, msgs);
			case J2se5Package.PACKAGE_DECLARATION__OWNED_PACKAGES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getOwnedPackages()).basicAdd(otherEnd, msgs);
			case J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetPackageDeclaration((PackageDeclaration)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case J2se5Package.PACKAGE_DECLARATION__OWNED_ELEMENTS:
				return ((InternalEList<?>)getOwnedElements()).basicRemove(otherEnd, msgs);
			case J2se5Package.PACKAGE_DECLARATION__MODEL:
				return basicSetModel(null, msgs);
			case J2se5Package.PACKAGE_DECLARATION__OWNED_PACKAGES:
				return ((InternalEList<?>)getOwnedPackages()).basicRemove(otherEnd, msgs);
			case J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION:
				return basicSetPackageDeclaration(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID) {
			case J2se5Package.PACKAGE_DECLARATION__MODEL:
				return eInternalContainer().eInverseRemove(this, J2se5Package.MODEL__OWNED_ELEMENTS, Model.class, msgs);
			case J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION:
				return eInternalContainer().eInverseRemove(this, J2se5Package.PACKAGE_DECLARATION__OWNED_PACKAGES, PackageDeclaration.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case J2se5Package.PACKAGE_DECLARATION__QUALIFIED_NAME:
				return getQualifiedName();
			case J2se5Package.PACKAGE_DECLARATION__OWNED_ELEMENTS:
				return getOwnedElements();
			case J2se5Package.PACKAGE_DECLARATION__MODEL:
				return getModel();
			case J2se5Package.PACKAGE_DECLARATION__OWNED_PACKAGES:
				return getOwnedPackages();
			case J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION:
				return getPackageDeclaration();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case J2se5Package.PACKAGE_DECLARATION__QUALIFIED_NAME:
				setQualifiedName((String)newValue);
				return;
			case J2se5Package.PACKAGE_DECLARATION__OWNED_ELEMENTS:
				getOwnedElements().clear();
				getOwnedElements().addAll((Collection<? extends AbstractTypeDeclaration>)newValue);
				return;
			case J2se5Package.PACKAGE_DECLARATION__MODEL:
				setModel((Model)newValue);
				return;
			case J2se5Package.PACKAGE_DECLARATION__OWNED_PACKAGES:
				getOwnedPackages().clear();
				getOwnedPackages().addAll((Collection<? extends PackageDeclaration>)newValue);
				return;
			case J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION:
				setPackageDeclaration((PackageDeclaration)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case J2se5Package.PACKAGE_DECLARATION__QUALIFIED_NAME:
				setQualifiedName(QUALIFIED_NAME_EDEFAULT);
				return;
			case J2se5Package.PACKAGE_DECLARATION__OWNED_ELEMENTS:
				getOwnedElements().clear();
				return;
			case J2se5Package.PACKAGE_DECLARATION__MODEL:
				setModel((Model)null);
				return;
			case J2se5Package.PACKAGE_DECLARATION__OWNED_PACKAGES:
				getOwnedPackages().clear();
				return;
			case J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION:
				setPackageDeclaration((PackageDeclaration)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case J2se5Package.PACKAGE_DECLARATION__QUALIFIED_NAME:
				return QUALIFIED_NAME_EDEFAULT == null ? qualifiedName != null : !QUALIFIED_NAME_EDEFAULT.equals(qualifiedName);
			case J2se5Package.PACKAGE_DECLARATION__OWNED_ELEMENTS:
				return ownedElements != null && !ownedElements.isEmpty();
			case J2se5Package.PACKAGE_DECLARATION__MODEL:
				return getModel() != null;
			case J2se5Package.PACKAGE_DECLARATION__OWNED_PACKAGES:
				return ownedPackages != null && !ownedPackages.isEmpty();
			case J2se5Package.PACKAGE_DECLARATION__PACKAGE_DECLARATION:
				return getPackageDeclaration() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (qualifiedName: ");
		result.append(qualifiedName);
		result.append(')');
		return result.toString();
	}

} //PackageDeclarationImpl
