/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *    Nicolas Bros (Mia-Software)
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.editor.actions;

import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.editors.EcoreEditor;
import org.eclipse.gmt.modisco.common.editor.ui.DialogUriSelection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenModelFromEmfRegistryAction implements IWorkbenchWindowActionDelegate {

	private IWorkbenchWindow window;

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	public void run(IAction action) {
		IWorkbenchPage activePage = this.window.getActivePage();
		if (activePage != null) {
			DialogUriSelection launcher = new DialogUriSelection(new Shell());
			if (launcher.open() == Window.OK) {
				String metamodelLocation = launcher.getUriSelected();
				try {
					IEditorInput input = new URIEditorInput(URI.createURI(metamodelLocation));

					IDE.openEditor(activePage, input, EcoreEditor.EDITOR_ID, true);
				} catch (PartInitException e) {
					e.printStackTrace();
					MoDiscoEditorPlugin.INSTANCE.log(e);
				}
			}
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}
}
