/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.editor.adapters;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;

/**
 * An item provider adapter for displaying in the model editor tree the list of instances which
 * match a search string provided by the user.
 */
public class SearchResultsItemProvider extends ItemProviderAdapter implements
		IStructuredItemContentProvider, IItemLabelProvider {

	/** The elements that match the search */
	private ArrayList<EObject> elements = new ArrayList<EObject>();

	/** The configuration of the editor */
	private final EditorConfiguration editorConfiguration;

	public SearchResultsItemProvider(AdapterFactory adapterFactory,
			EditorConfiguration editorConfiguration) {
		super(adapterFactory);
		this.editorConfiguration = editorConfiguration;
	}

	@Override
	public Collection<?> getElements(Object object) {
		return BigListItemProvider.splitElements(this, null, this.elements, this.adapterFactory,
				this.editorConfiguration, null);
	}

	@Override
	public Object getImage(Object object) {
		return null;
	}

	@Override
	public String getText(Object object) {
		// this is never displayed, since this element is the root
		return "Search Results";
	}

	/** Add this instance to the list of instances matching the search */
	public void add(EObject object) {
		this.elements.add(object);
	}
}
