/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.editor.editors;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * The left pane in the model editor, containing the list (tree) of metaclasses and the list of
 * model services
 */
public class LeftPane {

	/** The viewer where a list of metaclasses is shown */
	private final MetaclassViewer metaclassViewer;
	private final EditorConfiguration editorConfiguration;

	public LeftPane(Composite parent, EditorConfiguration editorConfiguration) {
		this.editorConfiguration = editorConfiguration;
		GridLayout gridLayout = new GridLayout(1, false);
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		parent.setLayout(gridLayout);

		MetaclassViewToolBar toolbar = createToolBar(parent);

		this.metaclassViewer = new MetaclassViewer(parent, editorConfiguration);

		GridData metaclassViewerGridData = new GridData();
		metaclassViewerGridData.grabExcessHorizontalSpace = true;
		metaclassViewerGridData.grabExcessVerticalSpace = true;
		metaclassViewerGridData.horizontalAlignment = SWT.FILL;
		metaclassViewerGridData.verticalAlignment = SWT.FILL;
		this.metaclassViewer.getViewer().getControl().setLayoutData(metaclassViewerGridData);

		toolbar.setMetaclassViewer(this.metaclassViewer);
	}

	private MetaclassViewToolBar createToolBar(Composite parent) {
		Composite toolBarComposite = new Composite(parent, SWT.BORDER);
		GridData toolBarGridData = new GridData();
		toolBarGridData.grabExcessHorizontalSpace = true;
		toolBarGridData.horizontalAlignment = SWT.FILL;
		toolBarComposite.setLayoutData(toolBarGridData);

		return new MetaclassViewToolBar(toolBarComposite, this.editorConfiguration);
	}

	public MetaclassViewer getMetaclassViewer() {
		return this.metaclassViewer;
	}
}
