/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.editor.editors;

import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration.MetaclassesSortMode;
import org.eclipse.gmt.modisco.common.editor.util.ImageProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MetaclassViewToolBar {
	private final ToolBar toolBar;
	private MetaclassViewer metaclassViewer;
	private ToolItem btnSortByName;
	private ToolItem btnSortByCount;
	private ToolItem btnShowMetaclassesFullQualifiedName;
	private ToolItem btnShowEmptyMetaclasses;
	private ToolItem btnGroupByPackage;
	private ToolItem btnDisplayInstancesOfSubclasses;
	private ToolItem btnDerivationTree;

	private final EditorConfiguration editorConfiguration;

	public MetaclassViewToolBar(Composite parent, EditorConfiguration editorConfiguration) {
		this.editorConfiguration = editorConfiguration;
		GridLayout gridLayout = new GridLayout(2, false);
		gridLayout.horizontalSpacing = 30;
		// the margins are set so that the metaclass pane is aligned with the tree pane
		gridLayout.marginHeight = 2;
		gridLayout.marginTop = 1;
		parent.setLayout(gridLayout);

		this.toolBar = new ToolBar(parent, SWT.NONE);
		GridData toolBarGridData = new GridData();
		toolBarGridData.grabExcessHorizontalSpace = false;
		toolBarGridData.horizontalAlignment = SWT.FILL;
		this.toolBar.setLayoutData(toolBarGridData);

		createToolButtons();
		initialize();
	}

	public void setMetaclassViewer(MetaclassViewer metaclassViewer) {
		this.metaclassViewer = metaclassViewer;
	}

	private void createToolButtons() {
		this.btnSortByName = new ToolItem(this.toolBar, SWT.RADIO);
		this.btnSortByName.setToolTipText("Sort by Name");
		this.btnSortByName.setImage(ImageProvider.getInstance().getSortInstancesIcon());
		this.btnSortByName.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MetaclassViewToolBar.this.metaclassViewer
						.setSortMode(EditorConfiguration.MetaclassesSortMode.ByName);
			}
		});

		this.btnSortByCount = new ToolItem(this.toolBar, SWT.RADIO);
		this.btnSortByCount.setToolTipText("Sort by Count");
		this.btnSortByCount.setImage(ImageProvider.getInstance().getSortNumericallyIcon());
		this.btnSortByCount.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MetaclassViewToolBar.this.metaclassViewer
						.setSortMode(EditorConfiguration.MetaclassesSortMode.ByCount);
			}
		});

		this.btnShowMetaclassesFullQualifiedName = new ToolItem(this.toolBar, SWT.CHECK);
		this.btnShowMetaclassesFullQualifiedName.setToolTipText("Show Full Qualified Names");
		this.btnShowMetaclassesFullQualifiedName.setImage(ImageProvider.getInstance()
				.getShowFullQualifiedNamesIcon());
		this.btnShowMetaclassesFullQualifiedName.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MetaclassViewToolBar.this.metaclassViewer
						.setShowMetaclassesFullQualifiedNames(MetaclassViewToolBar.this.btnShowMetaclassesFullQualifiedName
								.getSelection());
			}
		});

		this.btnShowEmptyMetaclasses = new ToolItem(this.toolBar, SWT.CHECK);
		this.btnShowEmptyMetaclasses.setToolTipText("Show Empty Metaclasses");
		this.btnShowEmptyMetaclasses.setImage(ImageProvider.getInstance()
				.getShowEmptyMetaclassesIcon());
		this.btnShowEmptyMetaclasses.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MetaclassViewToolBar.this.metaclassViewer
						.setShowEmptyMetaclasses(MetaclassViewToolBar.this.btnShowEmptyMetaclasses
								.getSelection());
			}
		});

		this.btnGroupByPackage = new ToolItem(this.toolBar, SWT.CHECK);
		this.btnGroupByPackage.setToolTipText("Group by Package");
		this.btnGroupByPackage.setImage(ImageProvider.getInstance().getPackageIcon());
		this.btnGroupByPackage.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MetaclassViewToolBar.this.metaclassViewer
						.setGroupByPackage(MetaclassViewToolBar.this.btnGroupByPackage
								.getSelection());
			}
		});

		this.btnDisplayInstancesOfSubclasses = new ToolItem(this.toolBar, SWT.CHECK);
		this.btnDisplayInstancesOfSubclasses.setToolTipText("Display Instances of Subclasses");
		this.btnDisplayInstancesOfSubclasses.setImage(ImageProvider.getInstance()
				.getDerivedInstancesIcon());
		this.btnDisplayInstancesOfSubclasses.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MetaclassViewToolBar.this.metaclassViewer
						.setDisplayInstancesOfSubclasses(MetaclassViewToolBar.this.btnDisplayInstancesOfSubclasses
								.getSelection());
			}
		});

		this.btnDerivationTree = new ToolItem(this.toolBar, SWT.CHECK);
		this.btnDerivationTree.setToolTipText("Show Derivation Tree");
		this.btnDerivationTree.setImage(ImageProvider.getInstance().getDerivationTreeIcon());
		this.btnDerivationTree.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				MetaclassViewToolBar.this.metaclassViewer
						.setShowDerivationTree(MetaclassViewToolBar.this.btnDerivationTree
								.getSelection());
				MetaclassViewToolBar.this.btnGroupByPackage
						.setEnabled(!MetaclassViewToolBar.this.btnDerivationTree.getSelection());
			}
		});
	}

	/** Initialize the tool bar buttons with their initial value */
	private void initialize() {
		MetaclassesSortMode metaclassesSortMode = this.editorConfiguration.getMetaclassesSortMode();
		if (metaclassesSortMode == MetaclassesSortMode.ByName) {
			this.btnSortByName.setSelection(true);
		} else if (metaclassesSortMode == MetaclassesSortMode.ByCount) {
			this.btnSortByCount.setSelection(true);
		}
		this.btnShowMetaclassesFullQualifiedName.setSelection(this.editorConfiguration
				.isShowMetaclassesFullQualifiedNames());
		this.btnShowEmptyMetaclasses
				.setSelection(this.editorConfiguration.isShowEmptyMetaclasses());
		this.btnGroupByPackage.setSelection(this.editorConfiguration.isGroupByPackage());
		this.btnDisplayInstancesOfSubclasses.setSelection(this.editorConfiguration
				.isDisplayInstancesOfSubclasses());
		this.btnDerivationTree.setSelection(this.editorConfiguration.isShowDerivationTree());

		this.btnGroupByPackage.setEnabled(!this.editorConfiguration.isShowDerivationTree());
	}
}
