/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.editor.util;


/** General utility functions */
public class Util {

	/** Unicode char for the ellipsis ("...") */
	public static final String ELLIPSIS = "\u2026";
	private static final int TRUNCATE_AFTER = 100;

	/**
	 * Truncate the given String before the first newline or a maximum number of characters,
	 * whichever comes first
	 * 
	 * @param str
	 *            the string to truncate
	 * @return the part of the given string before the first newline
	 */
	public static String truncateBeforeNewline(String str) {
		int index = str.indexOf('\r');
		if (index == -1) {
			index = str.indexOf('\n');
		}

		if (index != -1 && index > TRUNCATE_AFTER || index == -1 && str.length() > TRUNCATE_AFTER) {
			index = TRUNCATE_AFTER;
		}

		if (index != -1) {
			return str.substring(0, index) + ELLIPSIS;
		}
		return str;
	}
}
