/*******************************************************************************
 * Copyright (c) 2008, 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.core.amwpropparser;

import java.util.ArrayList;
import java.util.List;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/**
 * @author Gabriel Barbier
 *
 */
public class AmwPropContentHandler implements ContentHandler {

	public void characters(char[] value, int offset, int count) throws SAXException {
		if (this.startModelPath) {
			String path = new String(value, offset, count);
			this.weavedModelsPaths.add(path);
		}
	}

	public void endDocument() throws SAXException {
	}

	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if (localName.equals(this.modelPath)) {
			this.startModelPath = false;
		}
	}

	public void endPrefixMapping(String arg0) throws SAXException {
	}

	public void ignorableWhitespace(char[] arg0, int arg1, int arg2)
			throws SAXException {
	}

	public void processingInstruction(String arg0, String arg1)
			throws SAXException {
	}

	public void setDocumentLocator(Locator arg0) {
	}

	public void skippedEntity(String arg0) throws SAXException {
	}

	public void startDocument() throws SAXException {
	}

	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		if (localName.equals(this.modelPath)) {
			this.startModelPath = true;
		}
	}

	public void startPrefixMapping(String arg0, String arg1) {
	}

	private boolean startModelPath = false;
	final private String modelPath = "model-relative-path";
	final private List<String> weavedModelsPaths = new ArrayList<String>();
	
	public List<String> getWeavedModelsPaths() {
		return this.weavedModelsPaths;
	}
}
