/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.common.core.protocol;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

/**
 * The modisco protocol is used to refer to MoDisco models (uiCustom, query,
 * etc.).
 * 
 * modisco://<sub-protocol>/<model_name>
 * 
 * The modisco URI is composed of to names <model_name> and <sub-protocol>.
 * 
 * <model_name> is the name of the referred model.
 * 
 * <sub-protocol> represents the kind of model that the URI refers to. The
 * values of <sub-protocol> are defined through the
 * org.eclipse.gmt.modisco.common.core.protocolext extension point.
 * 
 * @author Grgoire Dup (Mia-Software)
 */
public class ModiscoResourceFactoryImpl extends XMIResourceFactoryImpl {

	/**
	 * Constructor for ModiscoResourceFactoryImpl.
	 */
	public ModiscoResourceFactoryImpl() {
		super();
	}

	/* (non-Javadoc)
	 * @see XMIResourceFactoryImpl#createResource(URI)
	 */
	@Override
	public Resource createResource(final URI uri) {
		Resource xmiResource = new XMIResourceImpl(uri) {
			/* (non-Javadoc)
			 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#getURIConverter()
			 */
			@Override
			protected URIConverter getURIConverter() {
				URIConverter uriConverter = super.getURIConverter();
				uriConverter.getURIHandlers().add(0, new ModiscoURIHandler());
				return uriConverter;
			}
		};
		return xmiResource;
	}

}
