/*******************************************************************************
 * Copyright (c) 2008, 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sbastien Minguet (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *    Fabien Giquel (Mia-Software)
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.core.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmt.modisco.common.core.CommonModiscoActivator;

public class Tools {
	
	/** Constant for the file encoding system property. */
	private static final String ENCODING_PROPERTY = "file.encoding"; //$NON-NLS-1$

	public static boolean saveModel(final Resource resource, final String outputLocation){
		final URI outputURI = URI.createFileURI(outputLocation);
		return Tools.saveModel(resource, outputURI);

	}

	public static boolean saveModel(final Resource resource, final URI outputURI){
		boolean success = true;
		Map<String, String> options = new HashMap<String, String>();			
		options.put(XMLResource.OPTION_ENCODING, System.getProperty(ENCODING_PROPERTY));	

		resource.setURI(outputURI);
		try {
			resource.save(options);
		} catch (IOException e) {
			success = false;
			IStatus status = new Status(IStatus.ERROR,
					CommonModiscoActivator.PLUGIN_ID,
					"Error happend while saving a resource:"
							+ resource.getURI(), e);
			CommonModiscoActivator.getDefault().getLog().log(status);
		}
		return success;

	}
	/**
	 * Saves a model as a file to the given path.
	 * 
	 * @param root
	 *            Root of the objects to be serialized in a file.
	 * @param path
	 *            File where the objects have to be saved.
	 * @throws IOException
	 *             Thrown if an I/O operation has failed or been interrupted during the saving process.
	 */
	public static void save(final EObject root, final String outputLocation) throws IOException {
		final URI modelURI = URI.createFileURI(outputLocation);
		Tools.save(root, modelURI);
	}
	/**
	 * Saves a model as a file to the given path.
	 * 
	 * @param root
	 *            Root of the objects to be serialized in a file.
	 * @param path
	 *            File where the objects have to be saved.
	 * @throws IOException
	 *             Thrown if an I/O operation has failed or been interrupted during the saving process.
	 */
	public static void save(final EObject root, final URI modelURI) throws IOException {
		final ResourceSet resourceSet = new ResourceSetImpl();
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(
				Resource.Factory.Registry.DEFAULT_EXTENSION, new XMIResourceFactoryImpl());
		final Resource newModelResource = resourceSet.createResource(modelURI);
		newModelResource.getContents().add(root);
		final Map<String, Object> options = new HashMap<String,Object>();
		options.put(XMLResource.OPTION_ENCODING, System.getProperty(ENCODING_PROPERTY));
		newModelResource.save(options);
	}
}
