/**
 * *******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sbastien Minguet (Mia-Software) - initial API and implementation
 *     Frdric Madiot (Mia-Software) - initial API and implementation
 *     Fabien Giquel (Mia-Software) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - initial API and implementation
 *     Erwan Breton (Sodifrance) - initial API and implementation
 * *******************************************************************************
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.j2se5;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Body Declaration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.BodyDeclaration#getOriginalRank <em>Original Rank</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.BodyDeclaration#getAbstractTypeDeclaration <em>Abstract Type Declaration</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.BodyDeclaration#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.BodyDeclaration#getAnonymousClassDeclarationOwner <em>Anonymous Class Declaration Owner</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.BodyDeclaration#getModifiers <em>Modifiers</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getBodyDeclaration()
 * @model abstract="true"
 * @generated
 */
public interface BodyDeclaration extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Original Rank</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Original Rank</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Original Rank</em>' attribute.
	 * @see #setOriginalRank(int)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getBodyDeclaration_OriginalRank()
	 * @model
	 * @generated
	 */
	int getOriginalRank();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.BodyDeclaration#getOriginalRank <em>Original Rank</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Original Rank</em>' attribute.
	 * @see #getOriginalRank()
	 * @generated
	 */
	void setOriginalRank(int value);

	/**
	 * Returns the value of the '<em><b>Abstract Type Declaration</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.gmt.modisco.j2se5.AbstractTypeDeclaration#getBodyDeclarations <em>Body Declarations</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Abstract Type Declaration</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Abstract Type Declaration</em>' container reference.
	 * @see #setAbstractTypeDeclaration(AbstractTypeDeclaration)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getBodyDeclaration_AbstractTypeDeclaration()
	 * @see org.eclipse.gmt.modisco.j2se5.AbstractTypeDeclaration#getBodyDeclarations
	 * @model opposite="bodyDeclarations"
	 * @generated
	 */
	AbstractTypeDeclaration getAbstractTypeDeclaration();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.BodyDeclaration#getAbstractTypeDeclaration <em>Abstract Type Declaration</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Abstract Type Declaration</em>' container reference.
	 * @see #getAbstractTypeDeclaration()
	 * @generated
	 */
	void setAbstractTypeDeclaration(AbstractTypeDeclaration value);

	/**
	 * Returns the value of the '<em><b>Annotations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.gmt.modisco.j2se5.Annotation}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Annotations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Annotations</em>' containment reference list.
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getBodyDeclaration_Annotations()
	 * @model containment="true"
	 * @generated
	 */
	EList<Annotation> getAnnotations();

	/**
	 * Returns the value of the '<em><b>Anonymous Class Declaration Owner</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.gmt.modisco.j2se5.AnonymousClassDeclaration#getBodyDeclarations <em>Body Declarations</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Anonymous Class Declaration Owner</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Anonymous Class Declaration Owner</em>' container reference.
	 * @see #setAnonymousClassDeclarationOwner(AnonymousClassDeclaration)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getBodyDeclaration_AnonymousClassDeclarationOwner()
	 * @see org.eclipse.gmt.modisco.j2se5.AnonymousClassDeclaration#getBodyDeclarations
	 * @model opposite="bodyDeclarations"
	 * @generated
	 */
	AnonymousClassDeclaration getAnonymousClassDeclarationOwner();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.BodyDeclaration#getAnonymousClassDeclarationOwner <em>Anonymous Class Declaration Owner</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Anonymous Class Declaration Owner</em>' container reference.
	 * @see #getAnonymousClassDeclarationOwner()
	 * @generated
	 */
	void setAnonymousClassDeclarationOwner(AnonymousClassDeclaration value);

	/**
	 * Returns the value of the '<em><b>Modifiers</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.gmt.modisco.j2se5.Modifier}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.gmt.modisco.j2se5.Modifier#getBodyDeclaration <em>Body Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Modifiers</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Modifiers</em>' containment reference list.
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getBodyDeclaration_Modifiers()
	 * @see org.eclipse.gmt.modisco.j2se5.Modifier#getBodyDeclaration
	 * @model opposite="BodyDeclaration" containment="true"
	 * @generated
	 */
	EList<Modifier> getModifiers();

} // BodyDeclaration
