/**
 * *******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sbastien Minguet (Mia-Software) - initial API and implementation
 *     Frdric Madiot (Mia-Software) - initial API and implementation
 *     Fabien Giquel (Mia-Software) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - initial API and implementation
 *     Erwan Breton (Sodifrance) - initial API and implementation
 * *******************************************************************************
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.j2se5;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>AST Node</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getComments <em>Comments</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalColumnNumber <em>Original Column Number</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalLastLineNumber <em>Original Last Line Number</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalLength <em>Original Length</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalLineNumber <em>Original Line Number</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalStartPosition <em>Original Start Position</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalCompilationUnit <em>Original Compilation Unit</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getASTNode()
 * @model abstract="true"
 * @generated
 */
public interface ASTNode extends EObject {
	/**
	 * Returns the value of the '<em><b>Comments</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.gmt.modisco.j2se5.Comment}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Comments</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Comments</em>' containment reference list.
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getASTNode_Comments()
	 * @model containment="true"
	 * @generated
	 */
	EList<Comment> getComments();

	/**
	 * Returns the value of the '<em><b>Original Column Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Original Column Number</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Original Column Number</em>' attribute.
	 * @see #setOriginalColumnNumber(int)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getASTNode_OriginalColumnNumber()
	 * @model
	 * @generated
	 */
	int getOriginalColumnNumber();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalColumnNumber <em>Original Column Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Original Column Number</em>' attribute.
	 * @see #getOriginalColumnNumber()
	 * @generated
	 */
	void setOriginalColumnNumber(int value);

	/**
	 * Returns the value of the '<em><b>Original Last Line Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Original Last Line Number</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Original Last Line Number</em>' attribute.
	 * @see #setOriginalLastLineNumber(int)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getASTNode_OriginalLastLineNumber()
	 * @model
	 * @generated
	 */
	int getOriginalLastLineNumber();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalLastLineNumber <em>Original Last Line Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Original Last Line Number</em>' attribute.
	 * @see #getOriginalLastLineNumber()
	 * @generated
	 */
	void setOriginalLastLineNumber(int value);

	/**
	 * Returns the value of the '<em><b>Original Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Original Length</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Original Length</em>' attribute.
	 * @see #setOriginalLength(int)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getASTNode_OriginalLength()
	 * @model
	 * @generated
	 */
	int getOriginalLength();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalLength <em>Original Length</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Original Length</em>' attribute.
	 * @see #getOriginalLength()
	 * @generated
	 */
	void setOriginalLength(int value);

	/**
	 * Returns the value of the '<em><b>Original Line Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Original Line Number</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Original Line Number</em>' attribute.
	 * @see #setOriginalLineNumber(int)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getASTNode_OriginalLineNumber()
	 * @model
	 * @generated
	 */
	int getOriginalLineNumber();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalLineNumber <em>Original Line Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Original Line Number</em>' attribute.
	 * @see #getOriginalLineNumber()
	 * @generated
	 */
	void setOriginalLineNumber(int value);

	/**
	 * Returns the value of the '<em><b>Original Start Position</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Original Start Position</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Original Start Position</em>' attribute.
	 * @see #setOriginalStartPosition(int)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getASTNode_OriginalStartPosition()
	 * @model
	 * @generated
	 */
	int getOriginalStartPosition();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalStartPosition <em>Original Start Position</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Original Start Position</em>' attribute.
	 * @see #getOriginalStartPosition()
	 * @generated
	 */
	void setOriginalStartPosition(int value);

	/**
	 * Returns the value of the '<em><b>Original Compilation Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Original Compilation Unit</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Original Compilation Unit</em>' reference.
	 * @see #setOriginalCompilationUnit(CompilationUnit)
	 * @see org.eclipse.gmt.modisco.j2se5.J2se5Package#getASTNode_OriginalCompilationUnit()
	 * @model
	 * @generated
	 */
	CompilationUnit getOriginalCompilationUnit();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.j2se5.ASTNode#getOriginalCompilationUnit <em>Original Compilation Unit</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Original Compilation Unit</em>' reference.
	 * @see #getOriginalCompilationUnit()
	 * @generated
	 */
	void setOriginalCompilationUnit(CompilationUnit value);

} // ASTNode
