/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.gmt.modisco.common.editor.adapters.MiaReflectiveItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.TransientItemProvider;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.util.ImageProvider;
import org.eclipse.gmt.modisco.common.editor.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeItemProvider
extends TransientItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider {
    protected EAttribute attribute;
    protected EObject parent;
    protected final EditorConfiguration editorConfiguration;

    public AttributeItemProvider(AdapterFactory adapterFactory, EObject parent, EAttribute attribute, EditorConfiguration editorConfiguration) {
        super(adapterFactory, parent);
        this.attribute = attribute;
        this.parent = parent;
        this.editorConfiguration = editorConfiguration;
        parent.eAdapters().add((Object)this);
    }

    public EAttribute getAttribute() {
        return this.attribute;
    }

    public void notifyChanged(Notification notification) {
        if (this.attribute == notification.getFeature()) {
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)this, true, true));
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)this.parent, true, true));
        }
    }

    public int getCount() {
        Object value = this.parent.eGet((EStructuralFeature)this.attribute);
        int count = this.attribute.isMany() ? ((List)value).size() : (value != null ? 1 : 0);
        return count;
    }

    public String getText(Object object) {
        Object value;
        String multiplicity = "";
        if (this.editorConfiguration.isShowMultiplicity()) {
            String multLow = this.attribute.isRequired() ? "1" : "0";
            String multHigh = this.attribute.isMany() ? "*" : "1";
            multiplicity = " [" + multLow + ".." + multHigh + "]";
        }
        String prefix = this.attribute.isDerived() ? "/" : "";
        String strCount = this.attribute.isMany() ? " (" + this.getCount() + ")" : "";
        String strValue = !this.attribute.isMany() ? ((value = this.parent.eGet((EStructuralFeature)this.attribute)) != null ? " = " + value.toString() : "") : "";
        strValue = Util.truncateBeforeNewline(strValue);
        return String.valueOf(prefix) + this.attribute.getName() + multiplicity + strCount + strValue;
    }

    public Object getImage(Object object) {
        return ImageProvider.getInstance().getAttributeIcon();
    }

    @Override
    public Object getParent(Object object) {
        return this.parent;
    }

    protected String getFeatureText(Object feature) {
        return this.attribute.getName();
    }

    public boolean hasChildren(Object object) {
        return this.attribute.isMany() && this.getCount() > 0;
    }

    @Override
    public Collection<?> getChildren(Object object) {
        if (this.attribute.isMany()) {
            ArrayList childrenList = new ArrayList();
            Object value = this.parent.eGet((EStructuralFeature)this.attribute);
            List elements = (List)value;
            childrenList.addAll(elements);
            return childrenList;
        }
        return Collections.EMPTY_LIST;
    }

    public Object getForeground(Object object) {
        if (this.getCount() == 0) {
            return IItemColorProvider.GRAYED_OUT_COLOR;
        }
        return super.getForeground(object);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            this.itemPropertyDescriptors = new ArrayList();
            MiaReflectiveItemProvider parentItemProvider = (MiaReflectiveItemProvider)this.adapterFactory.adapt((Notifier)this.parent, IItemPropertySource.class);
            List parentDescriptors = parentItemProvider.getPropertyDescriptors(this.parent);
            for (IItemPropertyDescriptor descriptor : parentDescriptors) {
                if (descriptor.getFeature((Object)this.parent) != this.attribute) continue;
                this.itemPropertyDescriptors.add(new ItemPropertyDescriptorDecorator(this.parent, descriptor){

                    public String getCategory(Object thisObject) {
                        return null;
                    }

                    public String getId(Object thisObject) {
                        return String.valueOf(AttributeItemProvider.this.attribute.getName()) + this.getDisplayName(thisObject);
                    }
                });
            }
        }
        return this.itemPropertyDescriptors;
    }
}

