/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.editor.adapters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.LinkItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.MiaReflectiveItemProvider;
import org.eclipse.gmt.modisco.common.editor.adapters.OperationCanceledException;
import org.eclipse.gmt.modisco.common.editor.adapters.ParentAdapter;
import org.eclipse.gmt.modisco.common.editor.adapters.TransientItemProvider;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.util.ImageProvider;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigListItemProvider
extends TransientItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private static int SPLIT_THRESHOLD = 1000;
    private static final int SHOW_PROGRESS_DIALOG_THRESHOLD = 5000;
    private List<EObject> elements;
    private int startIndex;
    private int endIndex;
    private Object parent;
    private EObject modelParent;
    private List<EObject> subList = null;

    public BigListItemProvider(List<EObject> elements, int startIndex, int endIndex, Object parent, EObject modelParent, AdapterFactory adapterFactory, EditorConfiguration editorConfiguration) {
        super(adapterFactory, modelParent);
        this.parent = parent;
        this.modelParent = modelParent;
        this.elements = elements;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    @Override
    public Collection<?> getChildren(Object object) {
        if (this.subList == null) {
            int endIndex = this.endIndex;
            if (endIndex > this.elements.size()) {
                endIndex = this.elements.size();
            }
            this.subList = this.startIndex > this.elements.size() ? Collections.emptyList() : this.elements.subList(this.startIndex, endIndex);
        }
        return this.subList;
    }

    @Override
    public Object getParent(Object object) {
        return this.parent;
    }

    public EObject getModelParent() {
        return this.modelParent;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.parent instanceof LinkItemProvider) {
            LinkItemProvider linkItemProvider = (LinkItemProvider)((Object)this.parent);
            return linkItemProvider.getChildrenFeatures(object);
        }
        return super.getChildrenFeatures(object);
    }

    public Object getImage(Object object) {
        return ImageProvider.getInstance().getRangeIcon();
    }

    public String getText(Object object) {
        int nElements = this.elements.size();
        int maxDigits = (int)Math.ceil(Math.log10(nElements));
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        String strStartIndex = "" + this.startIndex;
        String strEndIndex = "" + (this.endIndex - 1);
        this.zeroes(maxDigits - strStartIndex.length(), buffer);
        buffer.append(strStartIndex);
        buffer.append("..");
        this.zeroes(maxDigits - strEndIndex.length(), buffer);
        buffer.append(strEndIndex);
        buffer.append("]");
        return buffer.toString();
    }

    private void zeroes(int count, StringBuilder buffer) {
        int i = 0;
        while (i < count) {
            buffer.append('0');
            ++i;
        }
    }

    @Override
    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        return Collections.emptyList();
    }

    public static Collection<?> splitElements(Object parent, EObject modelParent, List<EObject> elements, AdapterFactory adapterFactory, EditorConfiguration editorConfiguration, Collection<?> previousElements) {
        boolean reuse;
        for (EObject element : elements) {
            ParentAdapter.associateParent(element, parent, (AdapterFactory)editorConfiguration.getAdapterFactory());
        }
        if (editorConfiguration.isSortInstances()) {
            BigListItemProvider.sortElements(elements, adapterFactory);
        }
        if (elements.size() <= SPLIT_THRESHOLD) {
            return elements;
        }
        Iterator<?> previousElementsIterator = null;
        boolean bl = reuse = previousElements != null;
        if (reuse) {
            previousElementsIterator = previousElements.iterator();
        }
        ArrayList<TransientItemProvider> subLists = new ArrayList<TransientItemProvider>();
        int start = 0;
        while (start < elements.size()) {
            int end = start + SPLIT_THRESHOLD;
            if (end > elements.size()) {
                end = elements.size();
            }
            TransientItemProvider bigListItemProvider = null;
            if (reuse && previousElementsIterator.hasNext()) {
                Object obj = previousElementsIterator.next();
                if (obj instanceof BigListItemProvider) {
                    bigListItemProvider = (BigListItemProvider)((Object)obj);
                } else {
                    reuse = false;
                }
            }
            if (bigListItemProvider == null) {
                bigListItemProvider = new BigListItemProvider(elements, start, end, parent, modelParent, adapterFactory, editorConfiguration);
            } else {
                bigListItemProvider.setParent(modelParent);
                ((BigListItemProvider)bigListItemProvider).elements = elements;
                ((BigListItemProvider)bigListItemProvider).startIndex = start;
                ((BigListItemProvider)bigListItemProvider).endIndex = end;
                ((BigListItemProvider)bigListItemProvider).parent = parent;
                ((BigListItemProvider)bigListItemProvider).modelParent = modelParent;
                ((BigListItemProvider)bigListItemProvider).adapterFactory = adapterFactory;
                ((BigListItemProvider)bigListItemProvider).subList = null;
            }
            subLists.add(bigListItemProvider);
            start += SPLIT_THRESHOLD;
        }
        return subLists;
    }

    private static void sortElements(final List<EObject> elements, final AdapterFactory adapterFactory) {
        IRunnableWithProgress sortOperation = new IRunnableWithProgress(){

            public void run(final IProgressMonitor monitor) {
                monitor.beginTask("Sorting instances", -1);
                Collections.sort(elements, new Comparator<EObject>(){
                    int count = 0;

                    @Override
                    public int compare(EObject e1, EObject e2) {
                        MiaReflectiveItemProvider itemProvider;
                        int metaclassComparison;
                        if (this.count++ % 1000 == 0) {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            Display.getDefault().readAndDispatch();
                        }
                        if ((metaclassComparison = e1.eClass().getName().compareToIgnoreCase(e2.eClass().getName())) != 0) {
                            return metaclassComparison;
                        }
                        String label1 = null;
                        String label2 = null;
                        IItemLabelProvider labelProvider1 = (IItemLabelProvider)adapterFactory.adapt((Notifier)e1, IItemLabelProvider.class);
                        IItemLabelProvider labelProvider2 = (IItemLabelProvider)adapterFactory.adapt((Notifier)e2, IItemLabelProvider.class);
                        if (labelProvider1 instanceof MiaReflectiveItemProvider) {
                            itemProvider = (MiaReflectiveItemProvider)labelProvider1;
                            label1 = itemProvider.getName(e1);
                        }
                        if (labelProvider2 instanceof MiaReflectiveItemProvider) {
                            itemProvider = (MiaReflectiveItemProvider)labelProvider2;
                            label2 = itemProvider.getName(e2);
                        }
                        if (label1 == null) {
                            label1 = labelProvider1.getText((Object)e1);
                        }
                        if (label2 == null) {
                            label2 = labelProvider2.getText((Object)e2);
                        }
                        return label1.compareToIgnoreCase(label2);
                    }
                });
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        Shell shell = window != null ? window.getShell() : null;
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            progressMonitorDialog.setOpenOnRun(elements.size() > 5000);
            progressMonitorDialog.run(false, true, sortOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (OperationCanceledException operationCanceledException) {}
    }
}

